/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Fulfillment;
import com.squareup.square.types.Money;
import com.squareup.square.types.OrderLineItem;
import com.squareup.square.types.OrderLineItemDiscount;
import com.squareup.square.types.OrderLineItemTax;
import com.squareup.square.types.OrderMoneyAmounts;
import com.squareup.square.types.OrderPricingOptions;
import com.squareup.square.types.OrderReturn;
import com.squareup.square.types.OrderReward;
import com.squareup.square.types.OrderRoundingAdjustment;
import com.squareup.square.types.OrderServiceCharge;
import com.squareup.square.types.OrderSource;
import com.squareup.square.types.OrderState;
import com.squareup.square.types.Refund;
import com.squareup.square.types.Tender;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Order {
    private final Optional<String> id;
    private final String locationId;
    private final Optional<String> referenceId;
    private final Optional<OrderSource> source;
    private final Optional<String> customerId;
    private final Optional<List<OrderLineItem>> lineItems;
    private final Optional<List<OrderLineItemTax>> taxes;
    private final Optional<List<OrderLineItemDiscount>> discounts;
    private final Optional<List<OrderServiceCharge>> serviceCharges;
    private final Optional<List<Fulfillment>> fulfillments;
    private final Optional<List<OrderReturn>> returns;
    private final Optional<OrderMoneyAmounts> returnAmounts;
    private final Optional<OrderMoneyAmounts> netAmounts;
    private final Optional<OrderRoundingAdjustment> roundingAdjustment;
    private final Optional<List<Tender>> tenders;
    private final Optional<List<Refund>> refunds;
    private final Optional<Map<String, Optional<String>>> metadata;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> closedAt;
    private final Optional<OrderState> state;
    private final Optional<Integer> version;
    private final Optional<Money> totalMoney;
    private final Optional<Money> totalTaxMoney;
    private final Optional<Money> totalDiscountMoney;
    private final Optional<Money> totalTipMoney;
    private final Optional<Money> totalServiceChargeMoney;
    private final Optional<String> ticketName;
    private final Optional<OrderPricingOptions> pricingOptions;
    private final Optional<List<OrderReward>> rewards;
    private final Optional<Money> netAmountDueMoney;
    private final Map<String, Object> additionalProperties;

    private Order(Optional<String> id, String locationId, Optional<String> referenceId, Optional<OrderSource> source, Optional<String> customerId, Optional<List<OrderLineItem>> lineItems, Optional<List<OrderLineItemTax>> taxes, Optional<List<OrderLineItemDiscount>> discounts, Optional<List<OrderServiceCharge>> serviceCharges, Optional<List<Fulfillment>> fulfillments, Optional<List<OrderReturn>> returns, Optional<OrderMoneyAmounts> returnAmounts, Optional<OrderMoneyAmounts> netAmounts, Optional<OrderRoundingAdjustment> roundingAdjustment, Optional<List<Tender>> tenders, Optional<List<Refund>> refunds, Optional<Map<String, Optional<String>>> metadata, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> closedAt, Optional<OrderState> state, Optional<Integer> version, Optional<Money> totalMoney, Optional<Money> totalTaxMoney, Optional<Money> totalDiscountMoney, Optional<Money> totalTipMoney, Optional<Money> totalServiceChargeMoney, Optional<String> ticketName, Optional<OrderPricingOptions> pricingOptions, Optional<List<OrderReward>> rewards, Optional<Money> netAmountDueMoney, Map<String, Object> additionalProperties) {
        this.id = id;
        this.locationId = locationId;
        this.referenceId = referenceId;
        this.source = source;
        this.customerId = customerId;
        this.lineItems = lineItems;
        this.taxes = taxes;
        this.discounts = discounts;
        this.serviceCharges = serviceCharges;
        this.fulfillments = fulfillments;
        this.returns = returns;
        this.returnAmounts = returnAmounts;
        this.netAmounts = netAmounts;
        this.roundingAdjustment = roundingAdjustment;
        this.tenders = tenders;
        this.refunds = refunds;
        this.metadata = metadata;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
        this.state = state;
        this.version = version;
        this.totalMoney = totalMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.totalTipMoney = totalTipMoney;
        this.totalServiceChargeMoney = totalServiceChargeMoney;
        this.ticketName = ticketName;
        this.pricingOptions = pricingOptions;
        this.rewards = rewards;
        this.netAmountDueMoney = netAmountDueMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonProperty(value="source")
    public Optional<OrderSource> getSource() {
        return this.source;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (this.customerId == null) {
            return Optional.empty();
        }
        return this.customerId;
    }

    @JsonIgnore
    public Optional<List<OrderLineItem>> getLineItems() {
        if (this.lineItems == null) {
            return Optional.empty();
        }
        return this.lineItems;
    }

    @JsonIgnore
    public Optional<List<OrderLineItemTax>> getTaxes() {
        if (this.taxes == null) {
            return Optional.empty();
        }
        return this.taxes;
    }

    @JsonIgnore
    public Optional<List<OrderLineItemDiscount>> getDiscounts() {
        if (this.discounts == null) {
            return Optional.empty();
        }
        return this.discounts;
    }

    @JsonIgnore
    public Optional<List<OrderServiceCharge>> getServiceCharges() {
        if (this.serviceCharges == null) {
            return Optional.empty();
        }
        return this.serviceCharges;
    }

    @JsonIgnore
    public Optional<List<Fulfillment>> getFulfillments() {
        if (this.fulfillments == null) {
            return Optional.empty();
        }
        return this.fulfillments;
    }

    @JsonProperty(value="returns")
    public Optional<List<OrderReturn>> getReturns() {
        return this.returns;
    }

    @JsonProperty(value="return_amounts")
    public Optional<OrderMoneyAmounts> getReturnAmounts() {
        return this.returnAmounts;
    }

    @JsonProperty(value="net_amounts")
    public Optional<OrderMoneyAmounts> getNetAmounts() {
        return this.netAmounts;
    }

    @JsonProperty(value="rounding_adjustment")
    public Optional<OrderRoundingAdjustment> getRoundingAdjustment() {
        return this.roundingAdjustment;
    }

    @JsonProperty(value="tenders")
    public Optional<List<Tender>> getTenders() {
        return this.tenders;
    }

    @JsonProperty(value="refunds")
    public Optional<List<Refund>> getRefunds() {
        return this.refunds;
    }

    @JsonIgnore
    public Optional<Map<String, Optional<String>>> getMetadata() {
        if (this.metadata == null) {
            return Optional.empty();
        }
        return this.metadata;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="closed_at")
    public Optional<String> getClosedAt() {
        return this.closedAt;
    }

    @JsonProperty(value="state")
    public Optional<OrderState> getState() {
        return this.state;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonProperty(value="total_money")
    public Optional<Money> getTotalMoney() {
        return this.totalMoney;
    }

    @JsonProperty(value="total_tax_money")
    public Optional<Money> getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    @JsonProperty(value="total_discount_money")
    public Optional<Money> getTotalDiscountMoney() {
        return this.totalDiscountMoney;
    }

    @JsonProperty(value="total_tip_money")
    public Optional<Money> getTotalTipMoney() {
        return this.totalTipMoney;
    }

    @JsonProperty(value="total_service_charge_money")
    public Optional<Money> getTotalServiceChargeMoney() {
        return this.totalServiceChargeMoney;
    }

    @JsonIgnore
    public Optional<String> getTicketName() {
        if (this.ticketName == null) {
            return Optional.empty();
        }
        return this.ticketName;
    }

    @JsonProperty(value="pricing_options")
    public Optional<OrderPricingOptions> getPricingOptions() {
        return this.pricingOptions;
    }

    @JsonProperty(value="rewards")
    public Optional<List<OrderReward>> getRewards() {
        return this.rewards;
    }

    @JsonProperty(value="net_amount_due_money")
    public Optional<Money> getNetAmountDueMoney() {
        return this.netAmountDueMoney;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_id")
    private Optional<String> _getCustomerId() {
        return this.customerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="line_items")
    private Optional<List<OrderLineItem>> _getLineItems() {
        return this.lineItems;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="taxes")
    private Optional<List<OrderLineItemTax>> _getTaxes() {
        return this.taxes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="discounts")
    private Optional<List<OrderLineItemDiscount>> _getDiscounts() {
        return this.discounts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="service_charges")
    private Optional<List<OrderServiceCharge>> _getServiceCharges() {
        return this.serviceCharges;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="fulfillments")
    private Optional<List<Fulfillment>> _getFulfillments() {
        return this.fulfillments;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="metadata")
    private Optional<Map<String, Optional<String>>> _getMetadata() {
        return this.metadata;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ticket_name")
    private Optional<String> _getTicketName() {
        return this.ticketName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Order && this.equalTo((Order)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Order other) {
        return this.id.equals(other.id) && this.locationId.equals(other.locationId) && this.referenceId.equals(other.referenceId) && this.source.equals(other.source) && this.customerId.equals(other.customerId) && this.lineItems.equals(other.lineItems) && this.taxes.equals(other.taxes) && this.discounts.equals(other.discounts) && this.serviceCharges.equals(other.serviceCharges) && this.fulfillments.equals(other.fulfillments) && this.returns.equals(other.returns) && this.returnAmounts.equals(other.returnAmounts) && this.netAmounts.equals(other.netAmounts) && this.roundingAdjustment.equals(other.roundingAdjustment) && this.tenders.equals(other.tenders) && this.refunds.equals(other.refunds) && this.metadata.equals(other.metadata) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.closedAt.equals(other.closedAt) && this.state.equals(other.state) && this.version.equals(other.version) && this.totalMoney.equals(other.totalMoney) && this.totalTaxMoney.equals(other.totalTaxMoney) && this.totalDiscountMoney.equals(other.totalDiscountMoney) && this.totalTipMoney.equals(other.totalTipMoney) && this.totalServiceChargeMoney.equals(other.totalServiceChargeMoney) && this.ticketName.equals(other.ticketName) && this.pricingOptions.equals(other.pricingOptions) && this.rewards.equals(other.rewards) && this.netAmountDueMoney.equals(other.netAmountDueMoney);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.referenceId, this.source, this.customerId, this.lineItems, this.taxes, this.discounts, this.serviceCharges, this.fulfillments, this.returns, this.returnAmounts, this.netAmounts, this.roundingAdjustment, this.tenders, this.refunds, this.metadata, this.createdAt, this.updatedAt, this.closedAt, this.state, this.version, this.totalMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalTipMoney, this.totalServiceChargeMoney, this.ticketName, this.pricingOptions, this.rewards, this.netAmountDueMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    _FinalStage {
        private String locationId;
        private Optional<Money> netAmountDueMoney = Optional.empty();
        private Optional<List<OrderReward>> rewards = Optional.empty();
        private Optional<OrderPricingOptions> pricingOptions = Optional.empty();
        private Optional<String> ticketName = Optional.empty();
        private Optional<Money> totalServiceChargeMoney = Optional.empty();
        private Optional<Money> totalTipMoney = Optional.empty();
        private Optional<Money> totalDiscountMoney = Optional.empty();
        private Optional<Money> totalTaxMoney = Optional.empty();
        private Optional<Money> totalMoney = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<OrderState> state = Optional.empty();
        private Optional<String> closedAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<Map<String, Optional<String>>> metadata = Optional.empty();
        private Optional<List<Refund>> refunds = Optional.empty();
        private Optional<List<Tender>> tenders = Optional.empty();
        private Optional<OrderRoundingAdjustment> roundingAdjustment = Optional.empty();
        private Optional<OrderMoneyAmounts> netAmounts = Optional.empty();
        private Optional<OrderMoneyAmounts> returnAmounts = Optional.empty();
        private Optional<List<OrderReturn>> returns = Optional.empty();
        private Optional<List<Fulfillment>> fulfillments = Optional.empty();
        private Optional<List<OrderServiceCharge>> serviceCharges = Optional.empty();
        private Optional<List<OrderLineItemDiscount>> discounts = Optional.empty();
        private Optional<List<OrderLineItemTax>> taxes = Optional.empty();
        private Optional<List<OrderLineItem>> lineItems = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        private Optional<OrderSource> source = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Order other) {
            this.id(other.getId());
            this.locationId(other.getLocationId());
            this.referenceId(other.getReferenceId());
            this.source(other.getSource());
            this.customerId(other.getCustomerId());
            this.lineItems(other.getLineItems());
            this.taxes(other.getTaxes());
            this.discounts(other.getDiscounts());
            this.serviceCharges(other.getServiceCharges());
            this.fulfillments(other.getFulfillments());
            this.returns(other.getReturns());
            this.returnAmounts(other.getReturnAmounts());
            this.netAmounts(other.getNetAmounts());
            this.roundingAdjustment(other.getRoundingAdjustment());
            this.tenders(other.getTenders());
            this.refunds(other.getRefunds());
            this.metadata(other.getMetadata());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.closedAt(other.getClosedAt());
            this.state(other.getState());
            this.version(other.getVersion());
            this.totalMoney(other.getTotalMoney());
            this.totalTaxMoney(other.getTotalTaxMoney());
            this.totalDiscountMoney(other.getTotalDiscountMoney());
            this.totalTipMoney(other.getTotalTipMoney());
            this.totalServiceChargeMoney(other.getTotalServiceChargeMoney());
            this.ticketName(other.getTicketName());
            this.pricingOptions(other.getPricingOptions());
            this.rewards(other.getRewards());
            this.netAmountDueMoney(other.getNetAmountDueMoney());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public _FinalStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        public _FinalStage netAmountDueMoney(Money netAmountDueMoney) {
            this.netAmountDueMoney = Optional.ofNullable(netAmountDueMoney);
            return this;
        }

        @Override
        @JsonSetter(value="net_amount_due_money", nulls=Nulls.SKIP)
        public _FinalStage netAmountDueMoney(Optional<Money> netAmountDueMoney) {
            this.netAmountDueMoney = netAmountDueMoney;
            return this;
        }

        @Override
        public _FinalStage rewards(List<OrderReward> rewards) {
            this.rewards = Optional.ofNullable(rewards);
            return this;
        }

        @Override
        @JsonSetter(value="rewards", nulls=Nulls.SKIP)
        public _FinalStage rewards(Optional<List<OrderReward>> rewards) {
            this.rewards = rewards;
            return this;
        }

        @Override
        public _FinalStage pricingOptions(OrderPricingOptions pricingOptions) {
            this.pricingOptions = Optional.ofNullable(pricingOptions);
            return this;
        }

        @Override
        @JsonSetter(value="pricing_options", nulls=Nulls.SKIP)
        public _FinalStage pricingOptions(Optional<OrderPricingOptions> pricingOptions) {
            this.pricingOptions = pricingOptions;
            return this;
        }

        @Override
        public _FinalStage ticketName(Nullable<String> ticketName) {
            this.ticketName = ticketName.isNull() ? null : (ticketName.isEmpty() ? Optional.empty() : Optional.of(ticketName.get()));
            return this;
        }

        @Override
        public _FinalStage ticketName(String ticketName) {
            this.ticketName = Optional.ofNullable(ticketName);
            return this;
        }

        @Override
        @JsonSetter(value="ticket_name", nulls=Nulls.SKIP)
        public _FinalStage ticketName(Optional<String> ticketName) {
            this.ticketName = ticketName;
            return this;
        }

        @Override
        public _FinalStage totalServiceChargeMoney(Money totalServiceChargeMoney) {
            this.totalServiceChargeMoney = Optional.ofNullable(totalServiceChargeMoney);
            return this;
        }

        @Override
        @JsonSetter(value="total_service_charge_money", nulls=Nulls.SKIP)
        public _FinalStage totalServiceChargeMoney(Optional<Money> totalServiceChargeMoney) {
            this.totalServiceChargeMoney = totalServiceChargeMoney;
            return this;
        }

        @Override
        public _FinalStage totalTipMoney(Money totalTipMoney) {
            this.totalTipMoney = Optional.ofNullable(totalTipMoney);
            return this;
        }

        @Override
        @JsonSetter(value="total_tip_money", nulls=Nulls.SKIP)
        public _FinalStage totalTipMoney(Optional<Money> totalTipMoney) {
            this.totalTipMoney = totalTipMoney;
            return this;
        }

        @Override
        public _FinalStage totalDiscountMoney(Money totalDiscountMoney) {
            this.totalDiscountMoney = Optional.ofNullable(totalDiscountMoney);
            return this;
        }

        @Override
        @JsonSetter(value="total_discount_money", nulls=Nulls.SKIP)
        public _FinalStage totalDiscountMoney(Optional<Money> totalDiscountMoney) {
            this.totalDiscountMoney = totalDiscountMoney;
            return this;
        }

        @Override
        public _FinalStage totalTaxMoney(Money totalTaxMoney) {
            this.totalTaxMoney = Optional.ofNullable(totalTaxMoney);
            return this;
        }

        @Override
        @JsonSetter(value="total_tax_money", nulls=Nulls.SKIP)
        public _FinalStage totalTaxMoney(Optional<Money> totalTaxMoney) {
            this.totalTaxMoney = totalTaxMoney;
            return this;
        }

        @Override
        public _FinalStage totalMoney(Money totalMoney) {
            this.totalMoney = Optional.ofNullable(totalMoney);
            return this;
        }

        @Override
        @JsonSetter(value="total_money", nulls=Nulls.SKIP)
        public _FinalStage totalMoney(Optional<Money> totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        @Override
        public _FinalStage version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage state(OrderState state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @Override
        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public _FinalStage state(Optional<OrderState> state) {
            this.state = state;
            return this;
        }

        @Override
        public _FinalStage closedAt(String closedAt) {
            this.closedAt = Optional.ofNullable(closedAt);
            return this;
        }

        @Override
        @JsonSetter(value="closed_at", nulls=Nulls.SKIP)
        public _FinalStage closedAt(Optional<String> closedAt) {
            this.closedAt = closedAt;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage metadata(Nullable<Map<String, Optional<String>>> metadata) {
            this.metadata = metadata.isNull() ? null : (metadata.isEmpty() ? Optional.empty() : Optional.of(metadata.get()));
            return this;
        }

        @Override
        public _FinalStage metadata(Map<String, Optional<String>> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Map<String, Optional<String>>> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage refunds(List<Refund> refunds) {
            this.refunds = Optional.ofNullable(refunds);
            return this;
        }

        @Override
        @JsonSetter(value="refunds", nulls=Nulls.SKIP)
        public _FinalStage refunds(Optional<List<Refund>> refunds) {
            this.refunds = refunds;
            return this;
        }

        @Override
        public _FinalStage tenders(List<Tender> tenders) {
            this.tenders = Optional.ofNullable(tenders);
            return this;
        }

        @Override
        @JsonSetter(value="tenders", nulls=Nulls.SKIP)
        public _FinalStage tenders(Optional<List<Tender>> tenders) {
            this.tenders = tenders;
            return this;
        }

        @Override
        public _FinalStage roundingAdjustment(OrderRoundingAdjustment roundingAdjustment) {
            this.roundingAdjustment = Optional.ofNullable(roundingAdjustment);
            return this;
        }

        @Override
        @JsonSetter(value="rounding_adjustment", nulls=Nulls.SKIP)
        public _FinalStage roundingAdjustment(Optional<OrderRoundingAdjustment> roundingAdjustment) {
            this.roundingAdjustment = roundingAdjustment;
            return this;
        }

        @Override
        public _FinalStage netAmounts(OrderMoneyAmounts netAmounts) {
            this.netAmounts = Optional.ofNullable(netAmounts);
            return this;
        }

        @Override
        @JsonSetter(value="net_amounts", nulls=Nulls.SKIP)
        public _FinalStage netAmounts(Optional<OrderMoneyAmounts> netAmounts) {
            this.netAmounts = netAmounts;
            return this;
        }

        @Override
        public _FinalStage returnAmounts(OrderMoneyAmounts returnAmounts) {
            this.returnAmounts = Optional.ofNullable(returnAmounts);
            return this;
        }

        @Override
        @JsonSetter(value="return_amounts", nulls=Nulls.SKIP)
        public _FinalStage returnAmounts(Optional<OrderMoneyAmounts> returnAmounts) {
            this.returnAmounts = returnAmounts;
            return this;
        }

        @Override
        public _FinalStage returns(List<OrderReturn> returns) {
            this.returns = Optional.ofNullable(returns);
            return this;
        }

        @Override
        @JsonSetter(value="returns", nulls=Nulls.SKIP)
        public _FinalStage returns(Optional<List<OrderReturn>> returns) {
            this.returns = returns;
            return this;
        }

        @Override
        public _FinalStage fulfillments(Nullable<List<Fulfillment>> fulfillments) {
            this.fulfillments = fulfillments.isNull() ? null : (fulfillments.isEmpty() ? Optional.empty() : Optional.of(fulfillments.get()));
            return this;
        }

        @Override
        public _FinalStage fulfillments(List<Fulfillment> fulfillments) {
            this.fulfillments = Optional.ofNullable(fulfillments);
            return this;
        }

        @Override
        @JsonSetter(value="fulfillments", nulls=Nulls.SKIP)
        public _FinalStage fulfillments(Optional<List<Fulfillment>> fulfillments) {
            this.fulfillments = fulfillments;
            return this;
        }

        @Override
        public _FinalStage serviceCharges(Nullable<List<OrderServiceCharge>> serviceCharges) {
            this.serviceCharges = serviceCharges.isNull() ? null : (serviceCharges.isEmpty() ? Optional.empty() : Optional.of(serviceCharges.get()));
            return this;
        }

        @Override
        public _FinalStage serviceCharges(List<OrderServiceCharge> serviceCharges) {
            this.serviceCharges = Optional.ofNullable(serviceCharges);
            return this;
        }

        @Override
        @JsonSetter(value="service_charges", nulls=Nulls.SKIP)
        public _FinalStage serviceCharges(Optional<List<OrderServiceCharge>> serviceCharges) {
            this.serviceCharges = serviceCharges;
            return this;
        }

        @Override
        public _FinalStage discounts(Nullable<List<OrderLineItemDiscount>> discounts) {
            this.discounts = discounts.isNull() ? null : (discounts.isEmpty() ? Optional.empty() : Optional.of(discounts.get()));
            return this;
        }

        @Override
        public _FinalStage discounts(List<OrderLineItemDiscount> discounts) {
            this.discounts = Optional.ofNullable(discounts);
            return this;
        }

        @Override
        @JsonSetter(value="discounts", nulls=Nulls.SKIP)
        public _FinalStage discounts(Optional<List<OrderLineItemDiscount>> discounts) {
            this.discounts = discounts;
            return this;
        }

        @Override
        public _FinalStage taxes(Nullable<List<OrderLineItemTax>> taxes) {
            this.taxes = taxes.isNull() ? null : (taxes.isEmpty() ? Optional.empty() : Optional.of(taxes.get()));
            return this;
        }

        @Override
        public _FinalStage taxes(List<OrderLineItemTax> taxes) {
            this.taxes = Optional.ofNullable(taxes);
            return this;
        }

        @Override
        @JsonSetter(value="taxes", nulls=Nulls.SKIP)
        public _FinalStage taxes(Optional<List<OrderLineItemTax>> taxes) {
            this.taxes = taxes;
            return this;
        }

        @Override
        public _FinalStage lineItems(Nullable<List<OrderLineItem>> lineItems) {
            this.lineItems = lineItems.isNull() ? null : (lineItems.isEmpty() ? Optional.empty() : Optional.of(lineItems.get()));
            return this;
        }

        @Override
        public _FinalStage lineItems(List<OrderLineItem> lineItems) {
            this.lineItems = Optional.ofNullable(lineItems);
            return this;
        }

        @Override
        @JsonSetter(value="line_items", nulls=Nulls.SKIP)
        public _FinalStage lineItems(Optional<List<OrderLineItem>> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        @Override
        public _FinalStage customerId(Nullable<String> customerId) {
            this.customerId = customerId.isNull() ? null : (customerId.isEmpty() ? Optional.empty() : Optional.of(customerId.get()));
            return this;
        }

        @Override
        public _FinalStage customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        @Override
        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public _FinalStage customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        @Override
        public _FinalStage source(OrderSource source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        @Override
        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public _FinalStage source(Optional<OrderSource> source) {
            this.source = source;
            return this;
        }

        @Override
        public _FinalStage referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @Override
        public _FinalStage referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        @Override
        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public _FinalStage referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public Order build() {
            return new Order(this.id, this.locationId, this.referenceId, this.source, this.customerId, this.lineItems, this.taxes, this.discounts, this.serviceCharges, this.fulfillments, this.returns, this.returnAmounts, this.netAmounts, this.roundingAdjustment, this.tenders, this.refunds, this.metadata, this.createdAt, this.updatedAt, this.closedAt, this.state, this.version, this.totalMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalTipMoney, this.totalServiceChargeMoney, this.ticketName, this.pricingOptions, this.rewards, this.netAmountDueMoney, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Order build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage referenceId(Optional<String> var1);

        public _FinalStage referenceId(String var1);

        public _FinalStage referenceId(Nullable<String> var1);

        public _FinalStage source(Optional<OrderSource> var1);

        public _FinalStage source(OrderSource var1);

        public _FinalStage customerId(Optional<String> var1);

        public _FinalStage customerId(String var1);

        public _FinalStage customerId(Nullable<String> var1);

        public _FinalStage lineItems(Optional<List<OrderLineItem>> var1);

        public _FinalStage lineItems(List<OrderLineItem> var1);

        public _FinalStage lineItems(Nullable<List<OrderLineItem>> var1);

        public _FinalStage taxes(Optional<List<OrderLineItemTax>> var1);

        public _FinalStage taxes(List<OrderLineItemTax> var1);

        public _FinalStage taxes(Nullable<List<OrderLineItemTax>> var1);

        public _FinalStage discounts(Optional<List<OrderLineItemDiscount>> var1);

        public _FinalStage discounts(List<OrderLineItemDiscount> var1);

        public _FinalStage discounts(Nullable<List<OrderLineItemDiscount>> var1);

        public _FinalStage serviceCharges(Optional<List<OrderServiceCharge>> var1);

        public _FinalStage serviceCharges(List<OrderServiceCharge> var1);

        public _FinalStage serviceCharges(Nullable<List<OrderServiceCharge>> var1);

        public _FinalStage fulfillments(Optional<List<Fulfillment>> var1);

        public _FinalStage fulfillments(List<Fulfillment> var1);

        public _FinalStage fulfillments(Nullable<List<Fulfillment>> var1);

        public _FinalStage returns(Optional<List<OrderReturn>> var1);

        public _FinalStage returns(List<OrderReturn> var1);

        public _FinalStage returnAmounts(Optional<OrderMoneyAmounts> var1);

        public _FinalStage returnAmounts(OrderMoneyAmounts var1);

        public _FinalStage netAmounts(Optional<OrderMoneyAmounts> var1);

        public _FinalStage netAmounts(OrderMoneyAmounts var1);

        public _FinalStage roundingAdjustment(Optional<OrderRoundingAdjustment> var1);

        public _FinalStage roundingAdjustment(OrderRoundingAdjustment var1);

        public _FinalStage tenders(Optional<List<Tender>> var1);

        public _FinalStage tenders(List<Tender> var1);

        public _FinalStage refunds(Optional<List<Refund>> var1);

        public _FinalStage refunds(List<Refund> var1);

        public _FinalStage metadata(Optional<Map<String, Optional<String>>> var1);

        public _FinalStage metadata(Map<String, Optional<String>> var1);

        public _FinalStage metadata(Nullable<Map<String, Optional<String>>> var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage closedAt(Optional<String> var1);

        public _FinalStage closedAt(String var1);

        public _FinalStage state(Optional<OrderState> var1);

        public _FinalStage state(OrderState var1);

        public _FinalStage version(Optional<Integer> var1);

        public _FinalStage version(Integer var1);

        public _FinalStage totalMoney(Optional<Money> var1);

        public _FinalStage totalMoney(Money var1);

        public _FinalStage totalTaxMoney(Optional<Money> var1);

        public _FinalStage totalTaxMoney(Money var1);

        public _FinalStage totalDiscountMoney(Optional<Money> var1);

        public _FinalStage totalDiscountMoney(Money var1);

        public _FinalStage totalTipMoney(Optional<Money> var1);

        public _FinalStage totalTipMoney(Money var1);

        public _FinalStage totalServiceChargeMoney(Optional<Money> var1);

        public _FinalStage totalServiceChargeMoney(Money var1);

        public _FinalStage ticketName(Optional<String> var1);

        public _FinalStage ticketName(String var1);

        public _FinalStage ticketName(Nullable<String> var1);

        public _FinalStage pricingOptions(Optional<OrderPricingOptions> var1);

        public _FinalStage pricingOptions(OrderPricingOptions var1);

        public _FinalStage rewards(Optional<List<OrderReward>> var1);

        public _FinalStage rewards(List<OrderReward> var1);

        public _FinalStage netAmountDueMoney(Optional<Money> var1);

        public _FinalStage netAmountDueMoney(Money var1);
    }

    public static interface LocationIdStage {
        public _FinalStage locationId(@NotNull String var1);

        public Builder from(Order var1);
    }
}

