/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class OrderFulfillmentType {
    public static final OrderFulfillmentType PICKUP = new OrderFulfillmentType(Value.PICKUP, "PICKUP");
    public static final OrderFulfillmentType SHIPMENT = new OrderFulfillmentType(Value.SHIPMENT, "SHIPMENT");
    public static final OrderFulfillmentType DELIVERY = new OrderFulfillmentType(Value.DELIVERY, "DELIVERY");
    private final Value value;
    private final String string;

    OrderFulfillmentType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof OrderFulfillmentType && this.string.equals(((OrderFulfillmentType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case PICKUP: {
                return visitor.visitPickup();
            }
            case SHIPMENT: {
                return visitor.visitShipment();
            }
            case DELIVERY: {
                return visitor.visitDelivery();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static OrderFulfillmentType valueOf(String value) {
        switch (value) {
            case "PICKUP": {
                return PICKUP;
            }
            case "SHIPMENT": {
                return SHIPMENT;
            }
            case "DELIVERY": {
                return DELIVERY;
            }
        }
        return new OrderFulfillmentType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitPickup();

        public T visitShipment();

        public T visitDelivery();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        PICKUP,
        SHIPMENT,
        DELIVERY,
        UNKNOWN;

    }
}

