/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderLineItemAppliedTax {
    private final Optional<String> uid;
    private final String taxUid;
    private final Optional<Money> appliedMoney;
    private final Map<String, Object> additionalProperties;

    private OrderLineItemAppliedTax(Optional<String> uid, String taxUid, Optional<Money> appliedMoney, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.taxUid = taxUid;
        this.appliedMoney = appliedMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonProperty(value="tax_uid")
    public String getTaxUid() {
        return this.taxUid;
    }

    @JsonProperty(value="applied_money")
    public Optional<Money> getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderLineItemAppliedTax && this.equalTo((OrderLineItemAppliedTax)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderLineItemAppliedTax other) {
        return this.uid.equals(other.uid) && this.taxUid.equals(other.taxUid) && this.appliedMoney.equals(other.appliedMoney);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.taxUid, this.appliedMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaxUidStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TaxUidStage,
    _FinalStage {
        private String taxUid;
        private Optional<Money> appliedMoney = Optional.empty();
        private Optional<String> uid = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrderLineItemAppliedTax other) {
            this.uid(other.getUid());
            this.taxUid(other.getTaxUid());
            this.appliedMoney(other.getAppliedMoney());
            return this;
        }

        @Override
        @JsonSetter(value="tax_uid")
        public _FinalStage taxUid(@NotNull String taxUid) {
            this.taxUid = Objects.requireNonNull(taxUid, "taxUid must not be null");
            return this;
        }

        @Override
        public _FinalStage appliedMoney(Money appliedMoney) {
            this.appliedMoney = Optional.ofNullable(appliedMoney);
            return this;
        }

        @Override
        @JsonSetter(value="applied_money", nulls=Nulls.SKIP)
        public _FinalStage appliedMoney(Optional<Money> appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        @Override
        public _FinalStage uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @Override
        public _FinalStage uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        @Override
        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public _FinalStage uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        @Override
        public OrderLineItemAppliedTax build() {
            return new OrderLineItemAppliedTax(this.uid, this.taxUid, this.appliedMoney, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrderLineItemAppliedTax build();

        public _FinalStage uid(Optional<String> var1);

        public _FinalStage uid(String var1);

        public _FinalStage uid(Nullable<String> var1);

        public _FinalStage appliedMoney(Optional<Money> var1);

        public _FinalStage appliedMoney(Money var1);
    }

    public static interface TaxUidStage {
        public _FinalStage taxUid(@NotNull String var1);

        public Builder from(OrderLineItemAppliedTax var1);
    }
}

