/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.OrderMoneyAmounts;
import com.squareup.square.types.OrderReturnDiscount;
import com.squareup.square.types.OrderReturnLineItem;
import com.squareup.square.types.OrderReturnServiceCharge;
import com.squareup.square.types.OrderReturnTax;
import com.squareup.square.types.OrderReturnTip;
import com.squareup.square.types.OrderRoundingAdjustment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderReturn {
    private final Optional<String> uid;
    private final Optional<String> sourceOrderId;
    private final Optional<List<OrderReturnLineItem>> returnLineItems;
    private final Optional<List<OrderReturnServiceCharge>> returnServiceCharges;
    private final Optional<List<OrderReturnTax>> returnTaxes;
    private final Optional<List<OrderReturnDiscount>> returnDiscounts;
    private final Optional<List<OrderReturnTip>> returnTips;
    private final Optional<OrderRoundingAdjustment> roundingAdjustment;
    private final Optional<OrderMoneyAmounts> returnAmounts;
    private final Map<String, Object> additionalProperties;

    private OrderReturn(Optional<String> uid, Optional<String> sourceOrderId, Optional<List<OrderReturnLineItem>> returnLineItems, Optional<List<OrderReturnServiceCharge>> returnServiceCharges, Optional<List<OrderReturnTax>> returnTaxes, Optional<List<OrderReturnDiscount>> returnDiscounts, Optional<List<OrderReturnTip>> returnTips, Optional<OrderRoundingAdjustment> roundingAdjustment, Optional<OrderMoneyAmounts> returnAmounts, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.sourceOrderId = sourceOrderId;
        this.returnLineItems = returnLineItems;
        this.returnServiceCharges = returnServiceCharges;
        this.returnTaxes = returnTaxes;
        this.returnDiscounts = returnDiscounts;
        this.returnTips = returnTips;
        this.roundingAdjustment = roundingAdjustment;
        this.returnAmounts = returnAmounts;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonIgnore
    public Optional<String> getSourceOrderId() {
        if (this.sourceOrderId == null) {
            return Optional.empty();
        }
        return this.sourceOrderId;
    }

    @JsonIgnore
    public Optional<List<OrderReturnLineItem>> getReturnLineItems() {
        if (this.returnLineItems == null) {
            return Optional.empty();
        }
        return this.returnLineItems;
    }

    @JsonIgnore
    public Optional<List<OrderReturnServiceCharge>> getReturnServiceCharges() {
        if (this.returnServiceCharges == null) {
            return Optional.empty();
        }
        return this.returnServiceCharges;
    }

    @JsonProperty(value="return_taxes")
    public Optional<List<OrderReturnTax>> getReturnTaxes() {
        return this.returnTaxes;
    }

    @JsonProperty(value="return_discounts")
    public Optional<List<OrderReturnDiscount>> getReturnDiscounts() {
        return this.returnDiscounts;
    }

    @JsonIgnore
    public Optional<List<OrderReturnTip>> getReturnTips() {
        if (this.returnTips == null) {
            return Optional.empty();
        }
        return this.returnTips;
    }

    @JsonProperty(value="rounding_adjustment")
    public Optional<OrderRoundingAdjustment> getRoundingAdjustment() {
        return this.roundingAdjustment;
    }

    @JsonProperty(value="return_amounts")
    public Optional<OrderMoneyAmounts> getReturnAmounts() {
        return this.returnAmounts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="source_order_id")
    private Optional<String> _getSourceOrderId() {
        return this.sourceOrderId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="return_line_items")
    private Optional<List<OrderReturnLineItem>> _getReturnLineItems() {
        return this.returnLineItems;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="return_service_charges")
    private Optional<List<OrderReturnServiceCharge>> _getReturnServiceCharges() {
        return this.returnServiceCharges;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="return_tips")
    private Optional<List<OrderReturnTip>> _getReturnTips() {
        return this.returnTips;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderReturn && this.equalTo((OrderReturn)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderReturn other) {
        return this.uid.equals(other.uid) && this.sourceOrderId.equals(other.sourceOrderId) && this.returnLineItems.equals(other.returnLineItems) && this.returnServiceCharges.equals(other.returnServiceCharges) && this.returnTaxes.equals(other.returnTaxes) && this.returnDiscounts.equals(other.returnDiscounts) && this.returnTips.equals(other.returnTips) && this.roundingAdjustment.equals(other.roundingAdjustment) && this.returnAmounts.equals(other.returnAmounts);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.sourceOrderId, this.returnLineItems, this.returnServiceCharges, this.returnTaxes, this.returnDiscounts, this.returnTips, this.roundingAdjustment, this.returnAmounts);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> uid = Optional.empty();
        private Optional<String> sourceOrderId = Optional.empty();
        private Optional<List<OrderReturnLineItem>> returnLineItems = Optional.empty();
        private Optional<List<OrderReturnServiceCharge>> returnServiceCharges = Optional.empty();
        private Optional<List<OrderReturnTax>> returnTaxes = Optional.empty();
        private Optional<List<OrderReturnDiscount>> returnDiscounts = Optional.empty();
        private Optional<List<OrderReturnTip>> returnTips = Optional.empty();
        private Optional<OrderRoundingAdjustment> roundingAdjustment = Optional.empty();
        private Optional<OrderMoneyAmounts> returnAmounts = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OrderReturn other) {
            this.uid(other.getUid());
            this.sourceOrderId(other.getSourceOrderId());
            this.returnLineItems(other.getReturnLineItems());
            this.returnServiceCharges(other.getReturnServiceCharges());
            this.returnTaxes(other.getReturnTaxes());
            this.returnDiscounts(other.getReturnDiscounts());
            this.returnTips(other.getReturnTips());
            this.roundingAdjustment(other.getRoundingAdjustment());
            this.returnAmounts(other.getReturnAmounts());
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        public Builder uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @JsonSetter(value="source_order_id", nulls=Nulls.SKIP)
        public Builder sourceOrderId(Optional<String> sourceOrderId) {
            this.sourceOrderId = sourceOrderId;
            return this;
        }

        public Builder sourceOrderId(String sourceOrderId) {
            this.sourceOrderId = Optional.ofNullable(sourceOrderId);
            return this;
        }

        public Builder sourceOrderId(Nullable<String> sourceOrderId) {
            this.sourceOrderId = sourceOrderId.isNull() ? null : (sourceOrderId.isEmpty() ? Optional.empty() : Optional.of(sourceOrderId.get()));
            return this;
        }

        @JsonSetter(value="return_line_items", nulls=Nulls.SKIP)
        public Builder returnLineItems(Optional<List<OrderReturnLineItem>> returnLineItems) {
            this.returnLineItems = returnLineItems;
            return this;
        }

        public Builder returnLineItems(List<OrderReturnLineItem> returnLineItems) {
            this.returnLineItems = Optional.ofNullable(returnLineItems);
            return this;
        }

        public Builder returnLineItems(Nullable<List<OrderReturnLineItem>> returnLineItems) {
            this.returnLineItems = returnLineItems.isNull() ? null : (returnLineItems.isEmpty() ? Optional.empty() : Optional.of(returnLineItems.get()));
            return this;
        }

        @JsonSetter(value="return_service_charges", nulls=Nulls.SKIP)
        public Builder returnServiceCharges(Optional<List<OrderReturnServiceCharge>> returnServiceCharges) {
            this.returnServiceCharges = returnServiceCharges;
            return this;
        }

        public Builder returnServiceCharges(List<OrderReturnServiceCharge> returnServiceCharges) {
            this.returnServiceCharges = Optional.ofNullable(returnServiceCharges);
            return this;
        }

        public Builder returnServiceCharges(Nullable<List<OrderReturnServiceCharge>> returnServiceCharges) {
            this.returnServiceCharges = returnServiceCharges.isNull() ? null : (returnServiceCharges.isEmpty() ? Optional.empty() : Optional.of(returnServiceCharges.get()));
            return this;
        }

        @JsonSetter(value="return_taxes", nulls=Nulls.SKIP)
        public Builder returnTaxes(Optional<List<OrderReturnTax>> returnTaxes) {
            this.returnTaxes = returnTaxes;
            return this;
        }

        public Builder returnTaxes(List<OrderReturnTax> returnTaxes) {
            this.returnTaxes = Optional.ofNullable(returnTaxes);
            return this;
        }

        @JsonSetter(value="return_discounts", nulls=Nulls.SKIP)
        public Builder returnDiscounts(Optional<List<OrderReturnDiscount>> returnDiscounts) {
            this.returnDiscounts = returnDiscounts;
            return this;
        }

        public Builder returnDiscounts(List<OrderReturnDiscount> returnDiscounts) {
            this.returnDiscounts = Optional.ofNullable(returnDiscounts);
            return this;
        }

        @JsonSetter(value="return_tips", nulls=Nulls.SKIP)
        public Builder returnTips(Optional<List<OrderReturnTip>> returnTips) {
            this.returnTips = returnTips;
            return this;
        }

        public Builder returnTips(List<OrderReturnTip> returnTips) {
            this.returnTips = Optional.ofNullable(returnTips);
            return this;
        }

        public Builder returnTips(Nullable<List<OrderReturnTip>> returnTips) {
            this.returnTips = returnTips.isNull() ? null : (returnTips.isEmpty() ? Optional.empty() : Optional.of(returnTips.get()));
            return this;
        }

        @JsonSetter(value="rounding_adjustment", nulls=Nulls.SKIP)
        public Builder roundingAdjustment(Optional<OrderRoundingAdjustment> roundingAdjustment) {
            this.roundingAdjustment = roundingAdjustment;
            return this;
        }

        public Builder roundingAdjustment(OrderRoundingAdjustment roundingAdjustment) {
            this.roundingAdjustment = Optional.ofNullable(roundingAdjustment);
            return this;
        }

        @JsonSetter(value="return_amounts", nulls=Nulls.SKIP)
        public Builder returnAmounts(Optional<OrderMoneyAmounts> returnAmounts) {
            this.returnAmounts = returnAmounts;
            return this;
        }

        public Builder returnAmounts(OrderMoneyAmounts returnAmounts) {
            this.returnAmounts = Optional.ofNullable(returnAmounts);
            return this;
        }

        public OrderReturn build() {
            return new OrderReturn(this.uid, this.sourceOrderId, this.returnLineItems, this.returnServiceCharges, this.returnTaxes, this.returnDiscounts, this.returnTips, this.roundingAdjustment, this.returnAmounts, this.additionalProperties);
        }
    }
}

