/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import com.squareup.square.types.OrderLineItemTaxScope;
import com.squareup.square.types.OrderLineItemTaxType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderReturnTax {
    private final Optional<String> uid;
    private final Optional<String> sourceTaxUid;
    private final Optional<String> catalogObjectId;
    private final Optional<Long> catalogVersion;
    private final Optional<String> name;
    private final Optional<OrderLineItemTaxType> type;
    private final Optional<String> percentage;
    private final Optional<Money> appliedMoney;
    private final Optional<OrderLineItemTaxScope> scope;
    private final Map<String, Object> additionalProperties;

    private OrderReturnTax(Optional<String> uid, Optional<String> sourceTaxUid, Optional<String> catalogObjectId, Optional<Long> catalogVersion, Optional<String> name, Optional<OrderLineItemTaxType> type, Optional<String> percentage, Optional<Money> appliedMoney, Optional<OrderLineItemTaxScope> scope, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.sourceTaxUid = sourceTaxUid;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.name = name;
        this.type = type;
        this.percentage = percentage;
        this.appliedMoney = appliedMoney;
        this.scope = scope;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonIgnore
    public Optional<String> getSourceTaxUid() {
        if (this.sourceTaxUid == null) {
            return Optional.empty();
        }
        return this.sourceTaxUid;
    }

    @JsonIgnore
    public Optional<String> getCatalogObjectId() {
        if (this.catalogObjectId == null) {
            return Optional.empty();
        }
        return this.catalogObjectId;
    }

    @JsonIgnore
    public Optional<Long> getCatalogVersion() {
        if (this.catalogVersion == null) {
            return Optional.empty();
        }
        return this.catalogVersion;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonProperty(value="type")
    public Optional<OrderLineItemTaxType> getType() {
        return this.type;
    }

    @JsonIgnore
    public Optional<String> getPercentage() {
        if (this.percentage == null) {
            return Optional.empty();
        }
        return this.percentage;
    }

    @JsonProperty(value="applied_money")
    public Optional<Money> getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonProperty(value="scope")
    public Optional<OrderLineItemTaxScope> getScope() {
        return this.scope;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="source_tax_uid")
    private Optional<String> _getSourceTaxUid() {
        return this.sourceTaxUid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_object_id")
    private Optional<String> _getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="catalog_version")
    private Optional<Long> _getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="percentage")
    private Optional<String> _getPercentage() {
        return this.percentage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderReturnTax && this.equalTo((OrderReturnTax)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderReturnTax other) {
        return this.uid.equals(other.uid) && this.sourceTaxUid.equals(other.sourceTaxUid) && this.catalogObjectId.equals(other.catalogObjectId) && this.catalogVersion.equals(other.catalogVersion) && this.name.equals(other.name) && this.type.equals(other.type) && this.percentage.equals(other.percentage) && this.appliedMoney.equals(other.appliedMoney) && this.scope.equals(other.scope);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.sourceTaxUid, this.catalogObjectId, this.catalogVersion, this.name, this.type, this.percentage, this.appliedMoney, this.scope);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> uid = Optional.empty();
        private Optional<String> sourceTaxUid = Optional.empty();
        private Optional<String> catalogObjectId = Optional.empty();
        private Optional<Long> catalogVersion = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<OrderLineItemTaxType> type = Optional.empty();
        private Optional<String> percentage = Optional.empty();
        private Optional<Money> appliedMoney = Optional.empty();
        private Optional<OrderLineItemTaxScope> scope = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OrderReturnTax other) {
            this.uid(other.getUid());
            this.sourceTaxUid(other.getSourceTaxUid());
            this.catalogObjectId(other.getCatalogObjectId());
            this.catalogVersion(other.getCatalogVersion());
            this.name(other.getName());
            this.type(other.getType());
            this.percentage(other.getPercentage());
            this.appliedMoney(other.getAppliedMoney());
            this.scope(other.getScope());
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        public Builder uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @JsonSetter(value="source_tax_uid", nulls=Nulls.SKIP)
        public Builder sourceTaxUid(Optional<String> sourceTaxUid) {
            this.sourceTaxUid = sourceTaxUid;
            return this;
        }

        public Builder sourceTaxUid(String sourceTaxUid) {
            this.sourceTaxUid = Optional.ofNullable(sourceTaxUid);
            return this;
        }

        public Builder sourceTaxUid(Nullable<String> sourceTaxUid) {
            this.sourceTaxUid = sourceTaxUid.isNull() ? null : (sourceTaxUid.isEmpty() ? Optional.empty() : Optional.of(sourceTaxUid.get()));
            return this;
        }

        @JsonSetter(value="catalog_object_id", nulls=Nulls.SKIP)
        public Builder catalogObjectId(Optional<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = Optional.ofNullable(catalogObjectId);
            return this;
        }

        public Builder catalogObjectId(Nullable<String> catalogObjectId) {
            this.catalogObjectId = catalogObjectId.isNull() ? null : (catalogObjectId.isEmpty() ? Optional.empty() : Optional.of(catalogObjectId.get()));
            return this;
        }

        @JsonSetter(value="catalog_version", nulls=Nulls.SKIP)
        public Builder catalogVersion(Optional<Long> catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = Optional.ofNullable(catalogVersion);
            return this;
        }

        public Builder catalogVersion(Nullable<Long> catalogVersion) {
            this.catalogVersion = catalogVersion.isNull() ? null : (catalogVersion.isEmpty() ? Optional.empty() : Optional.of(catalogVersion.get()));
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<OrderLineItemTaxType> type) {
            this.type = type;
            return this;
        }

        public Builder type(OrderLineItemTaxType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="percentage", nulls=Nulls.SKIP)
        public Builder percentage(Optional<String> percentage) {
            this.percentage = percentage;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = Optional.ofNullable(percentage);
            return this;
        }

        public Builder percentage(Nullable<String> percentage) {
            this.percentage = percentage.isNull() ? null : (percentage.isEmpty() ? Optional.empty() : Optional.of(percentage.get()));
            return this;
        }

        @JsonSetter(value="applied_money", nulls=Nulls.SKIP)
        public Builder appliedMoney(Optional<Money> appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = Optional.ofNullable(appliedMoney);
            return this;
        }

        @JsonSetter(value="scope", nulls=Nulls.SKIP)
        public Builder scope(Optional<OrderLineItemTaxScope> scope) {
            this.scope = scope;
            return this;
        }

        public Builder scope(OrderLineItemTaxScope scope) {
            this.scope = Optional.ofNullable(scope);
            return this;
        }

        public OrderReturnTax build() {
            return new OrderReturnTax(this.uid, this.sourceTaxUid, this.catalogObjectId, this.catalogVersion, this.name, this.type, this.percentage, this.appliedMoney, this.scope, this.additionalProperties);
        }
    }
}

