/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderReturnTip {
    private final Optional<String> uid;
    private final Optional<Money> appliedMoney;
    private final Optional<String> sourceTenderUid;
    private final Optional<String> sourceTenderId;
    private final Map<String, Object> additionalProperties;

    private OrderReturnTip(Optional<String> uid, Optional<Money> appliedMoney, Optional<String> sourceTenderUid, Optional<String> sourceTenderId, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.appliedMoney = appliedMoney;
        this.sourceTenderUid = sourceTenderUid;
        this.sourceTenderId = sourceTenderId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonProperty(value="applied_money")
    public Optional<Money> getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonIgnore
    public Optional<String> getSourceTenderUid() {
        if (this.sourceTenderUid == null) {
            return Optional.empty();
        }
        return this.sourceTenderUid;
    }

    @JsonIgnore
    public Optional<String> getSourceTenderId() {
        if (this.sourceTenderId == null) {
            return Optional.empty();
        }
        return this.sourceTenderId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="source_tender_uid")
    private Optional<String> _getSourceTenderUid() {
        return this.sourceTenderUid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="source_tender_id")
    private Optional<String> _getSourceTenderId() {
        return this.sourceTenderId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderReturnTip && this.equalTo((OrderReturnTip)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderReturnTip other) {
        return this.uid.equals(other.uid) && this.appliedMoney.equals(other.appliedMoney) && this.sourceTenderUid.equals(other.sourceTenderUid) && this.sourceTenderId.equals(other.sourceTenderId);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.appliedMoney, this.sourceTenderUid, this.sourceTenderId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> uid = Optional.empty();
        private Optional<Money> appliedMoney = Optional.empty();
        private Optional<String> sourceTenderUid = Optional.empty();
        private Optional<String> sourceTenderId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OrderReturnTip other) {
            this.uid(other.getUid());
            this.appliedMoney(other.getAppliedMoney());
            this.sourceTenderUid(other.getSourceTenderUid());
            this.sourceTenderId(other.getSourceTenderId());
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        public Builder uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @JsonSetter(value="applied_money", nulls=Nulls.SKIP)
        public Builder appliedMoney(Optional<Money> appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = Optional.ofNullable(appliedMoney);
            return this;
        }

        @JsonSetter(value="source_tender_uid", nulls=Nulls.SKIP)
        public Builder sourceTenderUid(Optional<String> sourceTenderUid) {
            this.sourceTenderUid = sourceTenderUid;
            return this;
        }

        public Builder sourceTenderUid(String sourceTenderUid) {
            this.sourceTenderUid = Optional.ofNullable(sourceTenderUid);
            return this;
        }

        public Builder sourceTenderUid(Nullable<String> sourceTenderUid) {
            this.sourceTenderUid = sourceTenderUid.isNull() ? null : (sourceTenderUid.isEmpty() ? Optional.empty() : Optional.of(sourceTenderUid.get()));
            return this;
        }

        @JsonSetter(value="source_tender_id", nulls=Nulls.SKIP)
        public Builder sourceTenderId(Optional<String> sourceTenderId) {
            this.sourceTenderId = sourceTenderId;
            return this;
        }

        public Builder sourceTenderId(String sourceTenderId) {
            this.sourceTenderId = Optional.ofNullable(sourceTenderId);
            return this;
        }

        public Builder sourceTenderId(Nullable<String> sourceTenderId) {
            this.sourceTenderId = sourceTenderId.isNull() ? null : (sourceTenderId.isEmpty() ? Optional.empty() : Optional.of(sourceTenderId.get()));
            return this;
        }

        public OrderReturnTip build() {
            return new OrderReturnTip(this.uid, this.appliedMoney, this.sourceTenderUid, this.sourceTenderId, this.additionalProperties);
        }
    }
}

