/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.OrderState;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderUpdated {
    private final Optional<String> orderId;
    private final Optional<Integer> version;
    private final Optional<String> locationId;
    private final Optional<OrderState> state;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Map<String, Object> additionalProperties;

    private OrderUpdated(Optional<String> orderId, Optional<Integer> version, Optional<String> locationId, Optional<OrderState> state, Optional<String> createdAt, Optional<String> updatedAt, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.version = version;
        this.locationId = locationId;
        this.state = state;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getOrderId() {
        if (this.orderId == null) {
            return Optional.empty();
        }
        return this.orderId;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonProperty(value="state")
    public Optional<OrderState> getState() {
        return this.state;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_id")
    private Optional<String> _getOrderId() {
        return this.orderId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderUpdated && this.equalTo((OrderUpdated)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderUpdated other) {
        return this.orderId.equals(other.orderId) && this.version.equals(other.version) && this.locationId.equals(other.locationId) && this.state.equals(other.state) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.version, this.locationId, this.state, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> orderId = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<OrderState> state = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(OrderUpdated other) {
            this.orderId(other.getOrderId());
            this.version(other.getVersion());
            this.locationId(other.getLocationId());
            this.state(other.getState());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public Builder orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        public Builder orderId(Nullable<String> orderId) {
            this.orderId = orderId.isNull() ? null : (orderId.isEmpty() ? Optional.empty() : Optional.of(orderId.get()));
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        public Builder version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<OrderState> state) {
            this.state = state;
            return this;
        }

        public Builder state(OrderState state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public OrderUpdated build() {
            return new OrderUpdated(this.orderId, this.version, this.locationId, this.state, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }
}

