/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ChangeTiming;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PauseSubscriptionRequest {
    private final String subscriptionId;
    private final Optional<String> pauseEffectiveDate;
    private final Optional<Long> pauseCycleDuration;
    private final Optional<String> resumeEffectiveDate;
    private final Optional<ChangeTiming> resumeChangeTiming;
    private final Optional<String> pauseReason;
    private final Map<String, Object> additionalProperties;

    private PauseSubscriptionRequest(String subscriptionId, Optional<String> pauseEffectiveDate, Optional<Long> pauseCycleDuration, Optional<String> resumeEffectiveDate, Optional<ChangeTiming> resumeChangeTiming, Optional<String> pauseReason, Map<String, Object> additionalProperties) {
        this.subscriptionId = subscriptionId;
        this.pauseEffectiveDate = pauseEffectiveDate;
        this.pauseCycleDuration = pauseCycleDuration;
        this.resumeEffectiveDate = resumeEffectiveDate;
        this.resumeChangeTiming = resumeChangeTiming;
        this.pauseReason = pauseReason;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="subscription_id")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonIgnore
    public Optional<String> getPauseEffectiveDate() {
        if (this.pauseEffectiveDate == null) {
            return Optional.empty();
        }
        return this.pauseEffectiveDate;
    }

    @JsonIgnore
    public Optional<Long> getPauseCycleDuration() {
        if (this.pauseCycleDuration == null) {
            return Optional.empty();
        }
        return this.pauseCycleDuration;
    }

    @JsonIgnore
    public Optional<String> getResumeEffectiveDate() {
        if (this.resumeEffectiveDate == null) {
            return Optional.empty();
        }
        return this.resumeEffectiveDate;
    }

    @JsonProperty(value="resume_change_timing")
    public Optional<ChangeTiming> getResumeChangeTiming() {
        return this.resumeChangeTiming;
    }

    @JsonIgnore
    public Optional<String> getPauseReason() {
        if (this.pauseReason == null) {
            return Optional.empty();
        }
        return this.pauseReason;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="pause_effective_date")
    private Optional<String> _getPauseEffectiveDate() {
        return this.pauseEffectiveDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="pause_cycle_duration")
    private Optional<Long> _getPauseCycleDuration() {
        return this.pauseCycleDuration;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="resume_effective_date")
    private Optional<String> _getResumeEffectiveDate() {
        return this.resumeEffectiveDate;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="pause_reason")
    private Optional<String> _getPauseReason() {
        return this.pauseReason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PauseSubscriptionRequest && this.equalTo((PauseSubscriptionRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PauseSubscriptionRequest other) {
        return this.subscriptionId.equals(other.subscriptionId) && this.pauseEffectiveDate.equals(other.pauseEffectiveDate) && this.pauseCycleDuration.equals(other.pauseCycleDuration) && this.resumeEffectiveDate.equals(other.resumeEffectiveDate) && this.resumeChangeTiming.equals(other.resumeChangeTiming) && this.pauseReason.equals(other.pauseReason);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionId, this.pauseEffectiveDate, this.pauseCycleDuration, this.resumeEffectiveDate, this.resumeChangeTiming, this.pauseReason);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SubscriptionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SubscriptionIdStage,
    _FinalStage {
        private String subscriptionId;
        private Optional<String> pauseReason = Optional.empty();
        private Optional<ChangeTiming> resumeChangeTiming = Optional.empty();
        private Optional<String> resumeEffectiveDate = Optional.empty();
        private Optional<Long> pauseCycleDuration = Optional.empty();
        private Optional<String> pauseEffectiveDate = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PauseSubscriptionRequest other) {
            this.subscriptionId(other.getSubscriptionId());
            this.pauseEffectiveDate(other.getPauseEffectiveDate());
            this.pauseCycleDuration(other.getPauseCycleDuration());
            this.resumeEffectiveDate(other.getResumeEffectiveDate());
            this.resumeChangeTiming(other.getResumeChangeTiming());
            this.pauseReason(other.getPauseReason());
            return this;
        }

        @Override
        @JsonSetter(value="subscription_id")
        public _FinalStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @Override
        public _FinalStage pauseReason(Nullable<String> pauseReason) {
            this.pauseReason = pauseReason.isNull() ? null : (pauseReason.isEmpty() ? Optional.empty() : Optional.of(pauseReason.get()));
            return this;
        }

        @Override
        public _FinalStage pauseReason(String pauseReason) {
            this.pauseReason = Optional.ofNullable(pauseReason);
            return this;
        }

        @Override
        @JsonSetter(value="pause_reason", nulls=Nulls.SKIP)
        public _FinalStage pauseReason(Optional<String> pauseReason) {
            this.pauseReason = pauseReason;
            return this;
        }

        @Override
        public _FinalStage resumeChangeTiming(ChangeTiming resumeChangeTiming) {
            this.resumeChangeTiming = Optional.ofNullable(resumeChangeTiming);
            return this;
        }

        @Override
        @JsonSetter(value="resume_change_timing", nulls=Nulls.SKIP)
        public _FinalStage resumeChangeTiming(Optional<ChangeTiming> resumeChangeTiming) {
            this.resumeChangeTiming = resumeChangeTiming;
            return this;
        }

        @Override
        public _FinalStage resumeEffectiveDate(Nullable<String> resumeEffectiveDate) {
            this.resumeEffectiveDate = resumeEffectiveDate.isNull() ? null : (resumeEffectiveDate.isEmpty() ? Optional.empty() : Optional.of(resumeEffectiveDate.get()));
            return this;
        }

        @Override
        public _FinalStage resumeEffectiveDate(String resumeEffectiveDate) {
            this.resumeEffectiveDate = Optional.ofNullable(resumeEffectiveDate);
            return this;
        }

        @Override
        @JsonSetter(value="resume_effective_date", nulls=Nulls.SKIP)
        public _FinalStage resumeEffectiveDate(Optional<String> resumeEffectiveDate) {
            this.resumeEffectiveDate = resumeEffectiveDate;
            return this;
        }

        @Override
        public _FinalStage pauseCycleDuration(Nullable<Long> pauseCycleDuration) {
            this.pauseCycleDuration = pauseCycleDuration.isNull() ? null : (pauseCycleDuration.isEmpty() ? Optional.empty() : Optional.of(pauseCycleDuration.get()));
            return this;
        }

        @Override
        public _FinalStage pauseCycleDuration(Long pauseCycleDuration) {
            this.pauseCycleDuration = Optional.ofNullable(pauseCycleDuration);
            return this;
        }

        @Override
        @JsonSetter(value="pause_cycle_duration", nulls=Nulls.SKIP)
        public _FinalStage pauseCycleDuration(Optional<Long> pauseCycleDuration) {
            this.pauseCycleDuration = pauseCycleDuration;
            return this;
        }

        @Override
        public _FinalStage pauseEffectiveDate(Nullable<String> pauseEffectiveDate) {
            this.pauseEffectiveDate = pauseEffectiveDate.isNull() ? null : (pauseEffectiveDate.isEmpty() ? Optional.empty() : Optional.of(pauseEffectiveDate.get()));
            return this;
        }

        @Override
        public _FinalStage pauseEffectiveDate(String pauseEffectiveDate) {
            this.pauseEffectiveDate = Optional.ofNullable(pauseEffectiveDate);
            return this;
        }

        @Override
        @JsonSetter(value="pause_effective_date", nulls=Nulls.SKIP)
        public _FinalStage pauseEffectiveDate(Optional<String> pauseEffectiveDate) {
            this.pauseEffectiveDate = pauseEffectiveDate;
            return this;
        }

        @Override
        public PauseSubscriptionRequest build() {
            return new PauseSubscriptionRequest(this.subscriptionId, this.pauseEffectiveDate, this.pauseCycleDuration, this.resumeEffectiveDate, this.resumeChangeTiming, this.pauseReason, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PauseSubscriptionRequest build();

        public _FinalStage pauseEffectiveDate(Optional<String> var1);

        public _FinalStage pauseEffectiveDate(String var1);

        public _FinalStage pauseEffectiveDate(Nullable<String> var1);

        public _FinalStage pauseCycleDuration(Optional<Long> var1);

        public _FinalStage pauseCycleDuration(Long var1);

        public _FinalStage pauseCycleDuration(Nullable<Long> var1);

        public _FinalStage resumeEffectiveDate(Optional<String> var1);

        public _FinalStage resumeEffectiveDate(String var1);

        public _FinalStage resumeEffectiveDate(Nullable<String> var1);

        public _FinalStage resumeChangeTiming(Optional<ChangeTiming> var1);

        public _FinalStage resumeChangeTiming(ChangeTiming var1);

        public _FinalStage pauseReason(Optional<String> var1);

        public _FinalStage pauseReason(String var1);

        public _FinalStage pauseReason(Nullable<String> var1);
    }

    public static interface SubscriptionIdStage {
        public _FinalStage subscriptionId(@NotNull String var1);

        public Builder from(PauseSubscriptionRequest var1);
    }
}

