/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaymentBalanceActivityTaxOnFeeDetail {
    private final Optional<String> paymentId;
    private final Optional<String> taxRateDescription;
    private final Map<String, Object> additionalProperties;

    private PaymentBalanceActivityTaxOnFeeDetail(Optional<String> paymentId, Optional<String> taxRateDescription, Map<String, Object> additionalProperties) {
        this.paymentId = paymentId;
        this.taxRateDescription = taxRateDescription;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getPaymentId() {
        if (this.paymentId == null) {
            return Optional.empty();
        }
        return this.paymentId;
    }

    @JsonIgnore
    public Optional<String> getTaxRateDescription() {
        if (this.taxRateDescription == null) {
            return Optional.empty();
        }
        return this.taxRateDescription;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_id")
    private Optional<String> _getPaymentId() {
        return this.paymentId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="tax_rate_description")
    private Optional<String> _getTaxRateDescription() {
        return this.taxRateDescription;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaymentBalanceActivityTaxOnFeeDetail && this.equalTo((PaymentBalanceActivityTaxOnFeeDetail)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaymentBalanceActivityTaxOnFeeDetail other) {
        return this.paymentId.equals(other.paymentId) && this.taxRateDescription.equals(other.taxRateDescription);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.taxRateDescription);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> paymentId = Optional.empty();
        private Optional<String> taxRateDescription = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PaymentBalanceActivityTaxOnFeeDetail other) {
            this.paymentId(other.getPaymentId());
            this.taxRateDescription(other.getTaxRateDescription());
            return this;
        }

        @JsonSetter(value="payment_id", nulls=Nulls.SKIP)
        public Builder paymentId(Optional<String> paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = Optional.ofNullable(paymentId);
            return this;
        }

        public Builder paymentId(Nullable<String> paymentId) {
            this.paymentId = paymentId.isNull() ? null : (paymentId.isEmpty() ? Optional.empty() : Optional.of(paymentId.get()));
            return this;
        }

        @JsonSetter(value="tax_rate_description", nulls=Nulls.SKIP)
        public Builder taxRateDescription(Optional<String> taxRateDescription) {
            this.taxRateDescription = taxRateDescription;
            return this;
        }

        public Builder taxRateDescription(String taxRateDescription) {
            this.taxRateDescription = Optional.ofNullable(taxRateDescription);
            return this;
        }

        public Builder taxRateDescription(Nullable<String> taxRateDescription) {
            this.taxRateDescription = taxRateDescription.isNull() ? null : (taxRateDescription.isEmpty() ? Optional.empty() : Optional.of(taxRateDescription.get()));
            return this;
        }

        public PaymentBalanceActivityTaxOnFeeDetail build() {
            return new PaymentBalanceActivityTaxOnFeeDetail(this.paymentId, this.taxRateDescription, this.additionalProperties);
        }
    }
}

