/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Payment;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaymentCreatedEventObject {
    private final Optional<Payment> payment;
    private final Map<String, Object> additionalProperties;

    private PaymentCreatedEventObject(Optional<Payment> payment, Map<String, Object> additionalProperties) {
        this.payment = payment;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="payment")
    public Optional<Payment> getPayment() {
        return this.payment;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaymentCreatedEventObject && this.equalTo((PaymentCreatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaymentCreatedEventObject other) {
        return this.payment.equals(other.payment);
    }

    public int hashCode() {
        return Objects.hash(this.payment);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Payment> payment = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PaymentCreatedEventObject other) {
            this.payment(other.getPayment());
            return this;
        }

        @JsonSetter(value="payment", nulls=Nulls.SKIP)
        public Builder payment(Optional<Payment> payment) {
            this.payment = payment;
            return this;
        }

        public Builder payment(Payment payment) {
            this.payment = Optional.ofNullable(payment);
            return this;
        }

        public PaymentCreatedEventObject build() {
            return new PaymentCreatedEventObject(this.payment, this.additionalProperties);
        }
    }
}

