/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CheckoutOptions;
import com.squareup.square.types.PrePopulatedData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaymentLink {
    private final Optional<String> id;
    private final int version;
    private final Optional<String> description;
    private final Optional<String> orderId;
    private final Optional<CheckoutOptions> checkoutOptions;
    private final Optional<PrePopulatedData> prePopulatedData;
    private final Optional<String> url;
    private final Optional<String> longUrl;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> paymentNote;
    private final Map<String, Object> additionalProperties;

    private PaymentLink(Optional<String> id, int version, Optional<String> description, Optional<String> orderId, Optional<CheckoutOptions> checkoutOptions, Optional<PrePopulatedData> prePopulatedData, Optional<String> url, Optional<String> longUrl, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> paymentNote, Map<String, Object> additionalProperties) {
        this.id = id;
        this.version = version;
        this.description = description;
        this.orderId = orderId;
        this.checkoutOptions = checkoutOptions;
        this.prePopulatedData = prePopulatedData;
        this.url = url;
        this.longUrl = longUrl;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.paymentNote = paymentNote;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonProperty(value="order_id")
    public Optional<String> getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="checkout_options")
    public Optional<CheckoutOptions> getCheckoutOptions() {
        return this.checkoutOptions;
    }

    @JsonProperty(value="pre_populated_data")
    public Optional<PrePopulatedData> getPrePopulatedData() {
        return this.prePopulatedData;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="long_url")
    public Optional<String> getLongUrl() {
        return this.longUrl;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<String> getPaymentNote() {
        if (this.paymentNote == null) {
            return Optional.empty();
        }
        return this.paymentNote;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_note")
    private Optional<String> _getPaymentNote() {
        return this.paymentNote;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaymentLink && this.equalTo((PaymentLink)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaymentLink other) {
        return this.id.equals(other.id) && this.version == other.version && this.description.equals(other.description) && this.orderId.equals(other.orderId) && this.checkoutOptions.equals(other.checkoutOptions) && this.prePopulatedData.equals(other.prePopulatedData) && this.url.equals(other.url) && this.longUrl.equals(other.longUrl) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.paymentNote.equals(other.paymentNote);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.description, this.orderId, this.checkoutOptions, this.prePopulatedData, this.url, this.longUrl, this.createdAt, this.updatedAt, this.paymentNote);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static VersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements VersionStage,
    _FinalStage {
        private int version;
        private Optional<String> paymentNote = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> longUrl = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<PrePopulatedData> prePopulatedData = Optional.empty();
        private Optional<CheckoutOptions> checkoutOptions = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PaymentLink other) {
            this.id(other.getId());
            this.version(other.getVersion());
            this.description(other.getDescription());
            this.orderId(other.getOrderId());
            this.checkoutOptions(other.getCheckoutOptions());
            this.prePopulatedData(other.getPrePopulatedData());
            this.url(other.getUrl());
            this.longUrl(other.getLongUrl());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.paymentNote(other.getPaymentNote());
            return this;
        }

        @Override
        @JsonSetter(value="version")
        public _FinalStage version(int version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage paymentNote(Nullable<String> paymentNote) {
            this.paymentNote = paymentNote.isNull() ? null : (paymentNote.isEmpty() ? Optional.empty() : Optional.of(paymentNote.get()));
            return this;
        }

        @Override
        public _FinalStage paymentNote(String paymentNote) {
            this.paymentNote = Optional.ofNullable(paymentNote);
            return this;
        }

        @Override
        @JsonSetter(value="payment_note", nulls=Nulls.SKIP)
        public _FinalStage paymentNote(Optional<String> paymentNote) {
            this.paymentNote = paymentNote;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage longUrl(String longUrl) {
            this.longUrl = Optional.ofNullable(longUrl);
            return this;
        }

        @Override
        @JsonSetter(value="long_url", nulls=Nulls.SKIP)
        public _FinalStage longUrl(Optional<String> longUrl) {
            this.longUrl = longUrl;
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage prePopulatedData(PrePopulatedData prePopulatedData) {
            this.prePopulatedData = Optional.ofNullable(prePopulatedData);
            return this;
        }

        @Override
        @JsonSetter(value="pre_populated_data", nulls=Nulls.SKIP)
        public _FinalStage prePopulatedData(Optional<PrePopulatedData> prePopulatedData) {
            this.prePopulatedData = prePopulatedData;
            return this;
        }

        @Override
        public _FinalStage checkoutOptions(CheckoutOptions checkoutOptions) {
            this.checkoutOptions = Optional.ofNullable(checkoutOptions);
            return this;
        }

        @Override
        @JsonSetter(value="checkout_options", nulls=Nulls.SKIP)
        public _FinalStage checkoutOptions(Optional<CheckoutOptions> checkoutOptions) {
            this.checkoutOptions = checkoutOptions;
            return this;
        }

        @Override
        public _FinalStage orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        @Override
        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public _FinalStage orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        @Override
        public _FinalStage description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public PaymentLink build() {
            return new PaymentLink(this.id, this.version, this.description, this.orderId, this.checkoutOptions, this.prePopulatedData, this.url, this.longUrl, this.createdAt, this.updatedAt, this.paymentNote, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PaymentLink build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage description(Nullable<String> var1);

        public _FinalStage orderId(Optional<String> var1);

        public _FinalStage orderId(String var1);

        public _FinalStage checkoutOptions(Optional<CheckoutOptions> var1);

        public _FinalStage checkoutOptions(CheckoutOptions var1);

        public _FinalStage prePopulatedData(Optional<PrePopulatedData> var1);

        public _FinalStage prePopulatedData(PrePopulatedData var1);

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);

        public _FinalStage longUrl(Optional<String> var1);

        public _FinalStage longUrl(String var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage paymentNote(Optional<String> var1);

        public _FinalStage paymentNote(String var1);

        public _FinalStage paymentNote(Nullable<String> var1);
    }

    public static interface VersionStage {
        public _FinalStage version(int var1);

        public Builder from(PaymentLink var1);
    }
}

