/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DestinationDetails;
import com.squareup.square.types.Money;
import com.squareup.square.types.ProcessingFee;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaymentRefund {
    private final String id;
    private final Optional<String> status;
    private final Optional<String> locationId;
    private final Optional<Boolean> unlinked;
    private final Optional<String> destinationType;
    private final Optional<DestinationDetails> destinationDetails;
    private final Money amountMoney;
    private final Optional<Money> appFeeMoney;
    private final Optional<List<ProcessingFee>> processingFee;
    private final Optional<String> paymentId;
    private final Optional<String> orderId;
    private final Optional<String> reason;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> teamMemberId;
    private final Optional<String> terminalRefundId;
    private final Map<String, Object> additionalProperties;

    private PaymentRefund(String id, Optional<String> status, Optional<String> locationId, Optional<Boolean> unlinked, Optional<String> destinationType, Optional<DestinationDetails> destinationDetails, Money amountMoney, Optional<Money> appFeeMoney, Optional<List<ProcessingFee>> processingFee, Optional<String> paymentId, Optional<String> orderId, Optional<String> reason, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> teamMemberId, Optional<String> terminalRefundId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.status = status;
        this.locationId = locationId;
        this.unlinked = unlinked;
        this.destinationType = destinationType;
        this.destinationDetails = destinationDetails;
        this.amountMoney = amountMoney;
        this.appFeeMoney = appFeeMoney;
        this.processingFee = processingFee;
        this.paymentId = paymentId;
        this.orderId = orderId;
        this.reason = reason;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.teamMemberId = teamMemberId;
        this.terminalRefundId = terminalRefundId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getStatus() {
        if (this.status == null) {
            return Optional.empty();
        }
        return this.status;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonProperty(value="unlinked")
    public Optional<Boolean> getUnlinked() {
        return this.unlinked;
    }

    @JsonIgnore
    public Optional<String> getDestinationType() {
        if (this.destinationType == null) {
            return Optional.empty();
        }
        return this.destinationType;
    }

    @JsonProperty(value="destination_details")
    public Optional<DestinationDetails> getDestinationDetails() {
        return this.destinationDetails;
    }

    @JsonProperty(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="app_fee_money")
    public Optional<Money> getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonIgnore
    public Optional<List<ProcessingFee>> getProcessingFee() {
        if (this.processingFee == null) {
            return Optional.empty();
        }
        return this.processingFee;
    }

    @JsonIgnore
    public Optional<String> getPaymentId() {
        if (this.paymentId == null) {
            return Optional.empty();
        }
        return this.paymentId;
    }

    @JsonIgnore
    public Optional<String> getOrderId() {
        if (this.orderId == null) {
            return Optional.empty();
        }
        return this.orderId;
    }

    @JsonIgnore
    public Optional<String> getReason() {
        if (this.reason == null) {
            return Optional.empty();
        }
        return this.reason;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="team_member_id")
    public Optional<String> getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonProperty(value="terminal_refund_id")
    public Optional<String> getTerminalRefundId() {
        return this.terminalRefundId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="status")
    private Optional<String> _getStatus() {
        return this.status;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="destination_type")
    private Optional<String> _getDestinationType() {
        return this.destinationType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="processing_fee")
    private Optional<List<ProcessingFee>> _getProcessingFee() {
        return this.processingFee;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_id")
    private Optional<String> _getPaymentId() {
        return this.paymentId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_id")
    private Optional<String> _getOrderId() {
        return this.orderId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reason")
    private Optional<String> _getReason() {
        return this.reason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaymentRefund && this.equalTo((PaymentRefund)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaymentRefund other) {
        return this.id.equals(other.id) && this.status.equals(other.status) && this.locationId.equals(other.locationId) && this.unlinked.equals(other.unlinked) && this.destinationType.equals(other.destinationType) && this.destinationDetails.equals(other.destinationDetails) && this.amountMoney.equals(other.amountMoney) && this.appFeeMoney.equals(other.appFeeMoney) && this.processingFee.equals(other.processingFee) && this.paymentId.equals(other.paymentId) && this.orderId.equals(other.orderId) && this.reason.equals(other.reason) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.teamMemberId.equals(other.teamMemberId) && this.terminalRefundId.equals(other.terminalRefundId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.locationId, this.unlinked, this.destinationType, this.destinationDetails, this.amountMoney, this.appFeeMoney, this.processingFee, this.paymentId, this.orderId, this.reason, this.createdAt, this.updatedAt, this.teamMemberId, this.terminalRefundId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    AmountMoneyStage,
    _FinalStage {
        private String id;
        private Money amountMoney;
        private Optional<String> terminalRefundId = Optional.empty();
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> reason = Optional.empty();
        private Optional<String> orderId = Optional.empty();
        private Optional<String> paymentId = Optional.empty();
        private Optional<List<ProcessingFee>> processingFee = Optional.empty();
        private Optional<Money> appFeeMoney = Optional.empty();
        private Optional<DestinationDetails> destinationDetails = Optional.empty();
        private Optional<String> destinationType = Optional.empty();
        private Optional<Boolean> unlinked = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PaymentRefund other) {
            this.id(other.getId());
            this.status(other.getStatus());
            this.locationId(other.getLocationId());
            this.unlinked(other.getUnlinked());
            this.destinationType(other.getDestinationType());
            this.destinationDetails(other.getDestinationDetails());
            this.amountMoney(other.getAmountMoney());
            this.appFeeMoney(other.getAppFeeMoney());
            this.processingFee(other.getProcessingFee());
            this.paymentId(other.getPaymentId());
            this.orderId(other.getOrderId());
            this.reason(other.getReason());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.teamMemberId(other.getTeamMemberId());
            this.terminalRefundId(other.getTerminalRefundId());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public AmountMoneyStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="amount_money")
        public _FinalStage amountMoney(@NotNull Money amountMoney) {
            this.amountMoney = Objects.requireNonNull(amountMoney, "amountMoney must not be null");
            return this;
        }

        @Override
        public _FinalStage terminalRefundId(String terminalRefundId) {
            this.terminalRefundId = Optional.ofNullable(terminalRefundId);
            return this;
        }

        @Override
        @JsonSetter(value="terminal_refund_id", nulls=Nulls.SKIP)
        public _FinalStage terminalRefundId(Optional<String> terminalRefundId) {
            this.terminalRefundId = terminalRefundId;
            return this;
        }

        @Override
        public _FinalStage teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        @Override
        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public _FinalStage teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage reason(Nullable<String> reason) {
            this.reason = reason.isNull() ? null : (reason.isEmpty() ? Optional.empty() : Optional.of(reason.get()));
            return this;
        }

        @Override
        public _FinalStage reason(String reason) {
            this.reason = Optional.ofNullable(reason);
            return this;
        }

        @Override
        @JsonSetter(value="reason", nulls=Nulls.SKIP)
        public _FinalStage reason(Optional<String> reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public _FinalStage orderId(Nullable<String> orderId) {
            this.orderId = orderId.isNull() ? null : (orderId.isEmpty() ? Optional.empty() : Optional.of(orderId.get()));
            return this;
        }

        @Override
        public _FinalStage orderId(String orderId) {
            this.orderId = Optional.ofNullable(orderId);
            return this;
        }

        @Override
        @JsonSetter(value="order_id", nulls=Nulls.SKIP)
        public _FinalStage orderId(Optional<String> orderId) {
            this.orderId = orderId;
            return this;
        }

        @Override
        public _FinalStage paymentId(Nullable<String> paymentId) {
            this.paymentId = paymentId.isNull() ? null : (paymentId.isEmpty() ? Optional.empty() : Optional.of(paymentId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentId(String paymentId) {
            this.paymentId = Optional.ofNullable(paymentId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_id", nulls=Nulls.SKIP)
        public _FinalStage paymentId(Optional<String> paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        @Override
        public _FinalStage processingFee(Nullable<List<ProcessingFee>> processingFee) {
            this.processingFee = processingFee.isNull() ? null : (processingFee.isEmpty() ? Optional.empty() : Optional.of(processingFee.get()));
            return this;
        }

        @Override
        public _FinalStage processingFee(List<ProcessingFee> processingFee) {
            this.processingFee = Optional.ofNullable(processingFee);
            return this;
        }

        @Override
        @JsonSetter(value="processing_fee", nulls=Nulls.SKIP)
        public _FinalStage processingFee(Optional<List<ProcessingFee>> processingFee) {
            this.processingFee = processingFee;
            return this;
        }

        @Override
        public _FinalStage appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = Optional.ofNullable(appFeeMoney);
            return this;
        }

        @Override
        @JsonSetter(value="app_fee_money", nulls=Nulls.SKIP)
        public _FinalStage appFeeMoney(Optional<Money> appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        @Override
        public _FinalStage destinationDetails(DestinationDetails destinationDetails) {
            this.destinationDetails = Optional.ofNullable(destinationDetails);
            return this;
        }

        @Override
        @JsonSetter(value="destination_details", nulls=Nulls.SKIP)
        public _FinalStage destinationDetails(Optional<DestinationDetails> destinationDetails) {
            this.destinationDetails = destinationDetails;
            return this;
        }

        @Override
        public _FinalStage destinationType(Nullable<String> destinationType) {
            this.destinationType = destinationType.isNull() ? null : (destinationType.isEmpty() ? Optional.empty() : Optional.of(destinationType.get()));
            return this;
        }

        @Override
        public _FinalStage destinationType(String destinationType) {
            this.destinationType = Optional.ofNullable(destinationType);
            return this;
        }

        @Override
        @JsonSetter(value="destination_type", nulls=Nulls.SKIP)
        public _FinalStage destinationType(Optional<String> destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public _FinalStage unlinked(Boolean unlinked) {
            this.unlinked = Optional.ofNullable(unlinked);
            return this;
        }

        @Override
        @JsonSetter(value="unlinked", nulls=Nulls.SKIP)
        public _FinalStage unlinked(Optional<Boolean> unlinked) {
            this.unlinked = unlinked;
            return this;
        }

        @Override
        public _FinalStage locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @Override
        public _FinalStage locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @Override
        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public _FinalStage locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        @Override
        public _FinalStage status(Nullable<String> status) {
            this.status = status.isNull() ? null : (status.isEmpty() ? Optional.empty() : Optional.of(status.get()));
            return this;
        }

        @Override
        public _FinalStage status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<String> status) {
            this.status = status;
            return this;
        }

        @Override
        public PaymentRefund build() {
            return new PaymentRefund(this.id, this.status, this.locationId, this.unlinked, this.destinationType, this.destinationDetails, this.amountMoney, this.appFeeMoney, this.processingFee, this.paymentId, this.orderId, this.reason, this.createdAt, this.updatedAt, this.teamMemberId, this.terminalRefundId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PaymentRefund build();

        public _FinalStage status(Optional<String> var1);

        public _FinalStage status(String var1);

        public _FinalStage status(Nullable<String> var1);

        public _FinalStage locationId(Optional<String> var1);

        public _FinalStage locationId(String var1);

        public _FinalStage locationId(Nullable<String> var1);

        public _FinalStage unlinked(Optional<Boolean> var1);

        public _FinalStage unlinked(Boolean var1);

        public _FinalStage destinationType(Optional<String> var1);

        public _FinalStage destinationType(String var1);

        public _FinalStage destinationType(Nullable<String> var1);

        public _FinalStage destinationDetails(Optional<DestinationDetails> var1);

        public _FinalStage destinationDetails(DestinationDetails var1);

        public _FinalStage appFeeMoney(Optional<Money> var1);

        public _FinalStage appFeeMoney(Money var1);

        public _FinalStage processingFee(Optional<List<ProcessingFee>> var1);

        public _FinalStage processingFee(List<ProcessingFee> var1);

        public _FinalStage processingFee(Nullable<List<ProcessingFee>> var1);

        public _FinalStage paymentId(Optional<String> var1);

        public _FinalStage paymentId(String var1);

        public _FinalStage paymentId(Nullable<String> var1);

        public _FinalStage orderId(Optional<String> var1);

        public _FinalStage orderId(String var1);

        public _FinalStage orderId(Nullable<String> var1);

        public _FinalStage reason(Optional<String> var1);

        public _FinalStage reason(String var1);

        public _FinalStage reason(Nullable<String> var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage teamMemberId(Optional<String> var1);

        public _FinalStage teamMemberId(String var1);

        public _FinalStage terminalRefundId(Optional<String> var1);

        public _FinalStage terminalRefundId(String var1);
    }

    public static interface AmountMoneyStage {
        public _FinalStage amountMoney(@NotNull Money var1);
    }

    public static interface IdStage {
        public AmountMoneyStage id(@NotNull String var1);

        public Builder from(PaymentRefund var1);
    }
}

