/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import com.squareup.square.types.PayoutFeeType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PayoutFee {
    private final Optional<Money> amountMoney;
    private final Optional<String> effectiveAt;
    private final Optional<PayoutFeeType> type;
    private final Map<String, Object> additionalProperties;

    private PayoutFee(Optional<Money> amountMoney, Optional<String> effectiveAt, Optional<PayoutFeeType> type, Map<String, Object> additionalProperties) {
        this.amountMoney = amountMoney;
        this.effectiveAt = effectiveAt;
        this.type = type;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="amount_money")
    public Optional<Money> getAmountMoney() {
        return this.amountMoney;
    }

    @JsonIgnore
    public Optional<String> getEffectiveAt() {
        if (this.effectiveAt == null) {
            return Optional.empty();
        }
        return this.effectiveAt;
    }

    @JsonProperty(value="type")
    public Optional<PayoutFeeType> getType() {
        return this.type;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="effective_at")
    private Optional<String> _getEffectiveAt() {
        return this.effectiveAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PayoutFee && this.equalTo((PayoutFee)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PayoutFee other) {
        return this.amountMoney.equals(other.amountMoney) && this.effectiveAt.equals(other.effectiveAt) && this.type.equals(other.type);
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.effectiveAt, this.type);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Money> amountMoney = Optional.empty();
        private Optional<String> effectiveAt = Optional.empty();
        private Optional<PayoutFeeType> type = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PayoutFee other) {
            this.amountMoney(other.getAmountMoney());
            this.effectiveAt(other.getEffectiveAt());
            this.type(other.getType());
            return this;
        }

        @JsonSetter(value="amount_money", nulls=Nulls.SKIP)
        public Builder amountMoney(Optional<Money> amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = Optional.ofNullable(amountMoney);
            return this;
        }

        @JsonSetter(value="effective_at", nulls=Nulls.SKIP)
        public Builder effectiveAt(Optional<String> effectiveAt) {
            this.effectiveAt = effectiveAt;
            return this;
        }

        public Builder effectiveAt(String effectiveAt) {
            this.effectiveAt = Optional.ofNullable(effectiveAt);
            return this;
        }

        public Builder effectiveAt(Nullable<String> effectiveAt) {
            this.effectiveAt = effectiveAt.isNull() ? null : (effectiveAt.isEmpty() ? Optional.empty() : Optional.of(effectiveAt.get()));
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<PayoutFeeType> type) {
            this.type = type;
            return this;
        }

        public Builder type(PayoutFeeType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        public PayoutFee build() {
            return new PayoutFee(this.amountMoney, this.effectiveAt, this.type, this.additionalProperties);
        }
    }
}

