/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class PayoutStatus {
    public static final PayoutStatus PAID = new PayoutStatus(Value.PAID, "PAID");
    public static final PayoutStatus SENT = new PayoutStatus(Value.SENT, "SENT");
    public static final PayoutStatus FAILED = new PayoutStatus(Value.FAILED, "FAILED");
    private final Value value;
    private final String string;

    PayoutStatus(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof PayoutStatus && this.string.equals(((PayoutStatus)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case PAID: {
                return visitor.visitPaid();
            }
            case SENT: {
                return visitor.visitSent();
            }
            case FAILED: {
                return visitor.visitFailed();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static PayoutStatus valueOf(String value) {
        switch (value) {
            case "PAID": {
                return PAID;
            }
            case "SENT": {
                return SENT;
            }
            case "FAILED": {
                return FAILED;
            }
        }
        return new PayoutStatus(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitSent();

        public T visitFailed();

        public T visitPaid();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        SENT,
        FAILED,
        PAID,
        UNKNOWN;

    }
}

