/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class PayoutType {
    public static final PayoutType BATCH = new PayoutType(Value.BATCH, "BATCH");
    public static final PayoutType SIMPLE = new PayoutType(Value.SIMPLE, "SIMPLE");
    private final Value value;
    private final String string;

    PayoutType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof PayoutType && this.string.equals(((PayoutType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case BATCH: {
                return visitor.visitBatch();
            }
            case SIMPLE: {
                return visitor.visitSimple();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static PayoutType valueOf(String value) {
        switch (value) {
            case "BATCH": {
                return BATCH;
            }
            case "SIMPLE": {
                return SIMPLE;
            }
        }
        return new PayoutType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitBatch();

        public T visitSimple();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        BATCH,
        SIMPLE,
        UNKNOWN;

    }
}

