/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Phase {
    private final Optional<String> uid;
    private final Optional<Long> ordinal;
    private final Optional<String> orderTemplateId;
    private final Optional<String> planPhaseUid;
    private final Map<String, Object> additionalProperties;

    private Phase(Optional<String> uid, Optional<Long> ordinal, Optional<String> orderTemplateId, Optional<String> planPhaseUid, Map<String, Object> additionalProperties) {
        this.uid = uid;
        this.ordinal = ordinal;
        this.orderTemplateId = orderTemplateId;
        this.planPhaseUid = planPhaseUid;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getUid() {
        if (this.uid == null) {
            return Optional.empty();
        }
        return this.uid;
    }

    @JsonIgnore
    public Optional<Long> getOrdinal() {
        if (this.ordinal == null) {
            return Optional.empty();
        }
        return this.ordinal;
    }

    @JsonIgnore
    public Optional<String> getOrderTemplateId() {
        if (this.orderTemplateId == null) {
            return Optional.empty();
        }
        return this.orderTemplateId;
    }

    @JsonIgnore
    public Optional<String> getPlanPhaseUid() {
        if (this.planPhaseUid == null) {
            return Optional.empty();
        }
        return this.planPhaseUid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uid")
    private Optional<String> _getUid() {
        return this.uid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ordinal")
    private Optional<Long> _getOrdinal() {
        return this.ordinal;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_template_id")
    private Optional<String> _getOrderTemplateId() {
        return this.orderTemplateId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="plan_phase_uid")
    private Optional<String> _getPlanPhaseUid() {
        return this.planPhaseUid;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Phase && this.equalTo((Phase)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Phase other) {
        return this.uid.equals(other.uid) && this.ordinal.equals(other.ordinal) && this.orderTemplateId.equals(other.orderTemplateId) && this.planPhaseUid.equals(other.planPhaseUid);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.ordinal, this.orderTemplateId, this.planPhaseUid);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> uid = Optional.empty();
        private Optional<Long> ordinal = Optional.empty();
        private Optional<String> orderTemplateId = Optional.empty();
        private Optional<String> planPhaseUid = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Phase other) {
            this.uid(other.getUid());
            this.ordinal(other.getOrdinal());
            this.orderTemplateId(other.getOrderTemplateId());
            this.planPhaseUid(other.getPlanPhaseUid());
            return this;
        }

        @JsonSetter(value="uid", nulls=Nulls.SKIP)
        public Builder uid(Optional<String> uid) {
            this.uid = uid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = Optional.ofNullable(uid);
            return this;
        }

        public Builder uid(Nullable<String> uid) {
            this.uid = uid.isNull() ? null : (uid.isEmpty() ? Optional.empty() : Optional.of(uid.get()));
            return this;
        }

        @JsonSetter(value="ordinal", nulls=Nulls.SKIP)
        public Builder ordinal(Optional<Long> ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder ordinal(Long ordinal) {
            this.ordinal = Optional.ofNullable(ordinal);
            return this;
        }

        public Builder ordinal(Nullable<Long> ordinal) {
            this.ordinal = ordinal.isNull() ? null : (ordinal.isEmpty() ? Optional.empty() : Optional.of(ordinal.get()));
            return this;
        }

        @JsonSetter(value="order_template_id", nulls=Nulls.SKIP)
        public Builder orderTemplateId(Optional<String> orderTemplateId) {
            this.orderTemplateId = orderTemplateId;
            return this;
        }

        public Builder orderTemplateId(String orderTemplateId) {
            this.orderTemplateId = Optional.ofNullable(orderTemplateId);
            return this;
        }

        public Builder orderTemplateId(Nullable<String> orderTemplateId) {
            this.orderTemplateId = orderTemplateId.isNull() ? null : (orderTemplateId.isEmpty() ? Optional.empty() : Optional.of(orderTemplateId.get()));
            return this;
        }

        @JsonSetter(value="plan_phase_uid", nulls=Nulls.SKIP)
        public Builder planPhaseUid(Optional<String> planPhaseUid) {
            this.planPhaseUid = planPhaseUid;
            return this;
        }

        public Builder planPhaseUid(String planPhaseUid) {
            this.planPhaseUid = Optional.ofNullable(planPhaseUid);
            return this;
        }

        public Builder planPhaseUid(Nullable<String> planPhaseUid) {
            this.planPhaseUid = planPhaseUid.isNull() ? null : (planPhaseUid.isEmpty() ? Optional.empty() : Optional.of(planPhaseUid.get()));
            return this;
        }

        public Phase build() {
            return new Phase(this.uid, this.ordinal, this.orderTemplateId, this.planPhaseUid, this.additionalProperties);
        }
    }
}

