/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ProcessingFee {
    private final Optional<String> effectiveAt;
    private final Optional<String> type;
    private final Optional<Money> amountMoney;
    private final Map<String, Object> additionalProperties;

    private ProcessingFee(Optional<String> effectiveAt, Optional<String> type, Optional<Money> amountMoney, Map<String, Object> additionalProperties) {
        this.effectiveAt = effectiveAt;
        this.type = type;
        this.amountMoney = amountMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getEffectiveAt() {
        if (this.effectiveAt == null) {
            return Optional.empty();
        }
        return this.effectiveAt;
    }

    @JsonIgnore
    public Optional<String> getType() {
        if (this.type == null) {
            return Optional.empty();
        }
        return this.type;
    }

    @JsonProperty(value="amount_money")
    public Optional<Money> getAmountMoney() {
        return this.amountMoney;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="effective_at")
    private Optional<String> _getEffectiveAt() {
        return this.effectiveAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="type")
    private Optional<String> _getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ProcessingFee && this.equalTo((ProcessingFee)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ProcessingFee other) {
        return this.effectiveAt.equals(other.effectiveAt) && this.type.equals(other.type) && this.amountMoney.equals(other.amountMoney);
    }

    public int hashCode() {
        return Objects.hash(this.effectiveAt, this.type, this.amountMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> effectiveAt = Optional.empty();
        private Optional<String> type = Optional.empty();
        private Optional<Money> amountMoney = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ProcessingFee other) {
            this.effectiveAt(other.getEffectiveAt());
            this.type(other.getType());
            this.amountMoney(other.getAmountMoney());
            return this;
        }

        @JsonSetter(value="effective_at", nulls=Nulls.SKIP)
        public Builder effectiveAt(Optional<String> effectiveAt) {
            this.effectiveAt = effectiveAt;
            return this;
        }

        public Builder effectiveAt(String effectiveAt) {
            this.effectiveAt = Optional.ofNullable(effectiveAt);
            return this;
        }

        public Builder effectiveAt(Nullable<String> effectiveAt) {
            this.effectiveAt = effectiveAt.isNull() ? null : (effectiveAt.isEmpty() ? Optional.empty() : Optional.of(effectiveAt.get()));
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        public Builder type(Nullable<String> type) {
            this.type = type.isNull() ? null : (type.isEmpty() ? Optional.empty() : Optional.of(type.get()));
            return this;
        }

        @JsonSetter(value="amount_money", nulls=Nulls.SKIP)
        public Builder amountMoney(Optional<Money> amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = Optional.ofNullable(amountMoney);
            return this;
        }

        public ProcessingFee build() {
            return new ProcessingFee(this.effectiveAt, this.type, this.amountMoney, this.additionalProperties);
        }
    }
}

