/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ScheduledShiftNotificationAudience;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PublishScheduledShiftRequest {
    private final String id;
    private final String idempotencyKey;
    private final Optional<Integer> version;
    private final Optional<ScheduledShiftNotificationAudience> scheduledShiftNotificationAudience;
    private final Map<String, Object> additionalProperties;

    private PublishScheduledShiftRequest(String id, String idempotencyKey, Optional<Integer> version, Optional<ScheduledShiftNotificationAudience> scheduledShiftNotificationAudience, Map<String, Object> additionalProperties) {
        this.id = id;
        this.idempotencyKey = idempotencyKey;
        this.version = version;
        this.scheduledShiftNotificationAudience = scheduledShiftNotificationAudience;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonProperty(value="scheduled_shift_notification_audience")
    public Optional<ScheduledShiftNotificationAudience> getScheduledShiftNotificationAudience() {
        return this.scheduledShiftNotificationAudience;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PublishScheduledShiftRequest && this.equalTo((PublishScheduledShiftRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PublishScheduledShiftRequest other) {
        return this.id.equals(other.id) && this.idempotencyKey.equals(other.idempotencyKey) && this.version.equals(other.version) && this.scheduledShiftNotificationAudience.equals(other.scheduledShiftNotificationAudience);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.idempotencyKey, this.version, this.scheduledShiftNotificationAudience);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    IdempotencyKeyStage,
    _FinalStage {
        private String id;
        private String idempotencyKey;
        private Optional<ScheduledShiftNotificationAudience> scheduledShiftNotificationAudience = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PublishScheduledShiftRequest other) {
            this.id(other.getId());
            this.idempotencyKey(other.getIdempotencyKey());
            this.version(other.getVersion());
            this.scheduledShiftNotificationAudience(other.getScheduledShiftNotificationAudience());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public IdempotencyKeyStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public _FinalStage scheduledShiftNotificationAudience(ScheduledShiftNotificationAudience scheduledShiftNotificationAudience) {
            this.scheduledShiftNotificationAudience = Optional.ofNullable(scheduledShiftNotificationAudience);
            return this;
        }

        @Override
        @JsonSetter(value="scheduled_shift_notification_audience", nulls=Nulls.SKIP)
        public _FinalStage scheduledShiftNotificationAudience(Optional<ScheduledShiftNotificationAudience> scheduledShiftNotificationAudience) {
            this.scheduledShiftNotificationAudience = scheduledShiftNotificationAudience;
            return this;
        }

        @Override
        public _FinalStage version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        @Override
        public PublishScheduledShiftRequest build() {
            return new PublishScheduledShiftRequest(this.id, this.idempotencyKey, this.version, this.scheduledShiftNotificationAudience, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PublishScheduledShiftRequest build();

        public _FinalStage version(Optional<Integer> var1);

        public _FinalStage version(Integer var1);

        public _FinalStage scheduledShiftNotificationAudience(Optional<ScheduledShiftNotificationAudience> var1);

        public _FinalStage scheduledShiftNotificationAudience(ScheduledShiftNotificationAudience var1);
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);
    }

    public static interface IdStage {
        public IdempotencyKeyStage id(@NotNull String var1);

        public Builder from(PublishScheduledShiftRequest var1);
    }
}

