/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class QrCodeOptions {
    private final String title;
    private final String body;
    private final String barcodeContents;
    private final Map<String, Object> additionalProperties;

    private QrCodeOptions(String title, String body, String barcodeContents, Map<String, Object> additionalProperties) {
        this.title = title;
        this.body = body;
        this.barcodeContents = barcodeContents;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="barcode_contents")
    public String getBarcodeContents() {
        return this.barcodeContents;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof QrCodeOptions && this.equalTo((QrCodeOptions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(QrCodeOptions other) {
        return this.title.equals(other.title) && this.body.equals(other.body) && this.barcodeContents.equals(other.barcodeContents);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.barcodeContents);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TitleStage,
    BodyStage,
    BarcodeContentsStage,
    _FinalStage {
        private String title;
        private String body;
        private String barcodeContents;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(QrCodeOptions other) {
            this.title(other.getTitle());
            this.body(other.getBody());
            this.barcodeContents(other.getBarcodeContents());
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public BodyStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public BarcodeContentsStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="barcode_contents")
        public _FinalStage barcodeContents(@NotNull String barcodeContents) {
            this.barcodeContents = Objects.requireNonNull(barcodeContents, "barcodeContents must not be null");
            return this;
        }

        @Override
        public QrCodeOptions build() {
            return new QrCodeOptions(this.title, this.body, this.barcodeContents, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public QrCodeOptions build();
    }

    public static interface BarcodeContentsStage {
        public _FinalStage barcodeContents(@NotNull String var1);
    }

    public static interface BodyStage {
        public BarcodeContentsStage body(@NotNull String var1);
    }

    public static interface TitleStage {
        public BodyStage title(@NotNull String var1);

        public Builder from(QrCodeOptions var1);
    }
}

