/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.AdditionalRecipient;
import com.squareup.square.types.Money;
import com.squareup.square.types.RefundStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Refund {
    private final String id;
    private final String locationId;
    private final Optional<String> transactionId;
    private final Optional<String> tenderId;
    private final Optional<String> createdAt;
    private final String reason;
    private final Money amountMoney;
    private final RefundStatus status;
    private final Optional<Money> processingFeeMoney;
    private final Optional<List<AdditionalRecipient>> additionalRecipients;
    private final Map<String, Object> additionalProperties;

    private Refund(String id, String locationId, Optional<String> transactionId, Optional<String> tenderId, Optional<String> createdAt, String reason, Money amountMoney, RefundStatus status, Optional<Money> processingFeeMoney, Optional<List<AdditionalRecipient>> additionalRecipients, Map<String, Object> additionalProperties) {
        this.id = id;
        this.locationId = locationId;
        this.transactionId = transactionId;
        this.tenderId = tenderId;
        this.createdAt = createdAt;
        this.reason = reason;
        this.amountMoney = amountMoney;
        this.status = status;
        this.processingFeeMoney = processingFeeMoney;
        this.additionalRecipients = additionalRecipients;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getTransactionId() {
        if (this.transactionId == null) {
            return Optional.empty();
        }
        return this.transactionId;
    }

    @JsonIgnore
    public Optional<String> getTenderId() {
        if (this.tenderId == null) {
            return Optional.empty();
        }
        return this.tenderId;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="status")
    public RefundStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="processing_fee_money")
    public Optional<Money> getProcessingFeeMoney() {
        return this.processingFeeMoney;
    }

    @JsonIgnore
    public Optional<List<AdditionalRecipient>> getAdditionalRecipients() {
        if (this.additionalRecipients == null) {
            return Optional.empty();
        }
        return this.additionalRecipients;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="transaction_id")
    private Optional<String> _getTransactionId() {
        return this.transactionId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="tender_id")
    private Optional<String> _getTenderId() {
        return this.tenderId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="additional_recipients")
    private Optional<List<AdditionalRecipient>> _getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Refund && this.equalTo((Refund)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Refund other) {
        return this.id.equals(other.id) && this.locationId.equals(other.locationId) && this.transactionId.equals(other.transactionId) && this.tenderId.equals(other.tenderId) && this.createdAt.equals(other.createdAt) && this.reason.equals(other.reason) && this.amountMoney.equals(other.amountMoney) && this.status.equals(other.status) && this.processingFeeMoney.equals(other.processingFeeMoney) && this.additionalRecipients.equals(other.additionalRecipients);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.transactionId, this.tenderId, this.createdAt, this.reason, this.amountMoney, this.status, this.processingFeeMoney, this.additionalRecipients);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    LocationIdStage,
    ReasonStage,
    AmountMoneyStage,
    StatusStage,
    _FinalStage {
        private String id;
        private String locationId;
        private String reason;
        private Money amountMoney;
        private RefundStatus status;
        private Optional<List<AdditionalRecipient>> additionalRecipients = Optional.empty();
        private Optional<Money> processingFeeMoney = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> tenderId = Optional.empty();
        private Optional<String> transactionId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Refund other) {
            this.id(other.getId());
            this.locationId(other.getLocationId());
            this.transactionId(other.getTransactionId());
            this.tenderId(other.getTenderId());
            this.createdAt(other.getCreatedAt());
            this.reason(other.getReason());
            this.amountMoney(other.getAmountMoney());
            this.status(other.getStatus());
            this.processingFeeMoney(other.getProcessingFeeMoney());
            this.additionalRecipients(other.getAdditionalRecipients());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public LocationIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public ReasonStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reason")
        public AmountMoneyStage reason(@NotNull String reason) {
            this.reason = Objects.requireNonNull(reason, "reason must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="amount_money")
        public StatusStage amountMoney(@NotNull Money amountMoney) {
            this.amountMoney = Objects.requireNonNull(amountMoney, "amountMoney must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public _FinalStage status(@NotNull RefundStatus status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        public _FinalStage additionalRecipients(Nullable<List<AdditionalRecipient>> additionalRecipients) {
            this.additionalRecipients = additionalRecipients.isNull() ? null : (additionalRecipients.isEmpty() ? Optional.empty() : Optional.of(additionalRecipients.get()));
            return this;
        }

        @Override
        public _FinalStage additionalRecipients(List<AdditionalRecipient> additionalRecipients) {
            this.additionalRecipients = Optional.ofNullable(additionalRecipients);
            return this;
        }

        @Override
        @JsonSetter(value="additional_recipients", nulls=Nulls.SKIP)
        public _FinalStage additionalRecipients(Optional<List<AdditionalRecipient>> additionalRecipients) {
            this.additionalRecipients = additionalRecipients;
            return this;
        }

        @Override
        public _FinalStage processingFeeMoney(Money processingFeeMoney) {
            this.processingFeeMoney = Optional.ofNullable(processingFeeMoney);
            return this;
        }

        @Override
        @JsonSetter(value="processing_fee_money", nulls=Nulls.SKIP)
        public _FinalStage processingFeeMoney(Optional<Money> processingFeeMoney) {
            this.processingFeeMoney = processingFeeMoney;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage tenderId(Nullable<String> tenderId) {
            this.tenderId = tenderId.isNull() ? null : (tenderId.isEmpty() ? Optional.empty() : Optional.of(tenderId.get()));
            return this;
        }

        @Override
        public _FinalStage tenderId(String tenderId) {
            this.tenderId = Optional.ofNullable(tenderId);
            return this;
        }

        @Override
        @JsonSetter(value="tender_id", nulls=Nulls.SKIP)
        public _FinalStage tenderId(Optional<String> tenderId) {
            this.tenderId = tenderId;
            return this;
        }

        @Override
        public _FinalStage transactionId(Nullable<String> transactionId) {
            this.transactionId = transactionId.isNull() ? null : (transactionId.isEmpty() ? Optional.empty() : Optional.of(transactionId.get()));
            return this;
        }

        @Override
        public _FinalStage transactionId(String transactionId) {
            this.transactionId = Optional.ofNullable(transactionId);
            return this;
        }

        @Override
        @JsonSetter(value="transaction_id", nulls=Nulls.SKIP)
        public _FinalStage transactionId(Optional<String> transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public Refund build() {
            return new Refund(this.id, this.locationId, this.transactionId, this.tenderId, this.createdAt, this.reason, this.amountMoney, this.status, this.processingFeeMoney, this.additionalRecipients, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Refund build();

        public _FinalStage transactionId(Optional<String> var1);

        public _FinalStage transactionId(String var1);

        public _FinalStage transactionId(Nullable<String> var1);

        public _FinalStage tenderId(Optional<String> var1);

        public _FinalStage tenderId(String var1);

        public _FinalStage tenderId(Nullable<String> var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage processingFeeMoney(Optional<Money> var1);

        public _FinalStage processingFeeMoney(Money var1);

        public _FinalStage additionalRecipients(Optional<List<AdditionalRecipient>> var1);

        public _FinalStage additionalRecipients(List<AdditionalRecipient> var1);

        public _FinalStage additionalRecipients(Nullable<List<AdditionalRecipient>> var1);
    }

    public static interface StatusStage {
        public _FinalStage status(@NotNull RefundStatus var1);
    }

    public static interface AmountMoneyStage {
        public StatusStage amountMoney(@NotNull Money var1);
    }

    public static interface ReasonStage {
        public AmountMoneyStage reason(@NotNull String var1);
    }

    public static interface LocationIdStage {
        public ReasonStage locationId(@NotNull String var1);
    }

    public static interface IdStage {
        public LocationIdStage id(@NotNull String var1);

        public Builder from(Refund var1);
    }
}

