/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DestinationDetailsCashRefundDetails;
import com.squareup.square.types.DestinationDetailsExternalRefundDetails;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RefundPaymentRequest {
    private final String idempotencyKey;
    private final Money amountMoney;
    private final Optional<Money> appFeeMoney;
    private final Optional<String> paymentId;
    private final Optional<String> destinationId;
    private final Optional<Boolean> unlinked;
    private final Optional<String> locationId;
    private final Optional<String> customerId;
    private final Optional<String> reason;
    private final Optional<String> paymentVersionToken;
    private final Optional<String> teamMemberId;
    private final Optional<DestinationDetailsCashRefundDetails> cashDetails;
    private final Optional<DestinationDetailsExternalRefundDetails> externalDetails;
    private final Map<String, Object> additionalProperties;

    private RefundPaymentRequest(String idempotencyKey, Money amountMoney, Optional<Money> appFeeMoney, Optional<String> paymentId, Optional<String> destinationId, Optional<Boolean> unlinked, Optional<String> locationId, Optional<String> customerId, Optional<String> reason, Optional<String> paymentVersionToken, Optional<String> teamMemberId, Optional<DestinationDetailsCashRefundDetails> cashDetails, Optional<DestinationDetailsExternalRefundDetails> externalDetails, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.amountMoney = amountMoney;
        this.appFeeMoney = appFeeMoney;
        this.paymentId = paymentId;
        this.destinationId = destinationId;
        this.unlinked = unlinked;
        this.locationId = locationId;
        this.customerId = customerId;
        this.reason = reason;
        this.paymentVersionToken = paymentVersionToken;
        this.teamMemberId = teamMemberId;
        this.cashDetails = cashDetails;
        this.externalDetails = externalDetails;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonProperty(value="app_fee_money")
    public Optional<Money> getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonIgnore
    public Optional<String> getPaymentId() {
        if (this.paymentId == null) {
            return Optional.empty();
        }
        return this.paymentId;
    }

    @JsonIgnore
    public Optional<String> getDestinationId() {
        if (this.destinationId == null) {
            return Optional.empty();
        }
        return this.destinationId;
    }

    @JsonIgnore
    public Optional<Boolean> getUnlinked() {
        if (this.unlinked == null) {
            return Optional.empty();
        }
        return this.unlinked;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (this.customerId == null) {
            return Optional.empty();
        }
        return this.customerId;
    }

    @JsonIgnore
    public Optional<String> getReason() {
        if (this.reason == null) {
            return Optional.empty();
        }
        return this.reason;
    }

    @JsonIgnore
    public Optional<String> getPaymentVersionToken() {
        if (this.paymentVersionToken == null) {
            return Optional.empty();
        }
        return this.paymentVersionToken;
    }

    @JsonIgnore
    public Optional<String> getTeamMemberId() {
        if (this.teamMemberId == null) {
            return Optional.empty();
        }
        return this.teamMemberId;
    }

    @JsonProperty(value="cash_details")
    public Optional<DestinationDetailsCashRefundDetails> getCashDetails() {
        return this.cashDetails;
    }

    @JsonProperty(value="external_details")
    public Optional<DestinationDetailsExternalRefundDetails> getExternalDetails() {
        return this.externalDetails;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_id")
    private Optional<String> _getPaymentId() {
        return this.paymentId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="destination_id")
    private Optional<String> _getDestinationId() {
        return this.destinationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="unlinked")
    private Optional<Boolean> _getUnlinked() {
        return this.unlinked;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_id")
    private Optional<String> _getCustomerId() {
        return this.customerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reason")
    private Optional<String> _getReason() {
        return this.reason;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_version_token")
    private Optional<String> _getPaymentVersionToken() {
        return this.paymentVersionToken;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_id")
    private Optional<String> _getTeamMemberId() {
        return this.teamMemberId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RefundPaymentRequest && this.equalTo((RefundPaymentRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RefundPaymentRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.amountMoney.equals(other.amountMoney) && this.appFeeMoney.equals(other.appFeeMoney) && this.paymentId.equals(other.paymentId) && this.destinationId.equals(other.destinationId) && this.unlinked.equals(other.unlinked) && this.locationId.equals(other.locationId) && this.customerId.equals(other.customerId) && this.reason.equals(other.reason) && this.paymentVersionToken.equals(other.paymentVersionToken) && this.teamMemberId.equals(other.teamMemberId) && this.cashDetails.equals(other.cashDetails) && this.externalDetails.equals(other.externalDetails);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.amountMoney, this.appFeeMoney, this.paymentId, this.destinationId, this.unlinked, this.locationId, this.customerId, this.reason, this.paymentVersionToken, this.teamMemberId, this.cashDetails, this.externalDetails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    AmountMoneyStage,
    _FinalStage {
        private String idempotencyKey;
        private Money amountMoney;
        private Optional<DestinationDetailsExternalRefundDetails> externalDetails = Optional.empty();
        private Optional<DestinationDetailsCashRefundDetails> cashDetails = Optional.empty();
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<String> paymentVersionToken = Optional.empty();
        private Optional<String> reason = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<Boolean> unlinked = Optional.empty();
        private Optional<String> destinationId = Optional.empty();
        private Optional<String> paymentId = Optional.empty();
        private Optional<Money> appFeeMoney = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RefundPaymentRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.amountMoney(other.getAmountMoney());
            this.appFeeMoney(other.getAppFeeMoney());
            this.paymentId(other.getPaymentId());
            this.destinationId(other.getDestinationId());
            this.unlinked(other.getUnlinked());
            this.locationId(other.getLocationId());
            this.customerId(other.getCustomerId());
            this.reason(other.getReason());
            this.paymentVersionToken(other.getPaymentVersionToken());
            this.teamMemberId(other.getTeamMemberId());
            this.cashDetails(other.getCashDetails());
            this.externalDetails(other.getExternalDetails());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public AmountMoneyStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="amount_money")
        public _FinalStage amountMoney(@NotNull Money amountMoney) {
            this.amountMoney = Objects.requireNonNull(amountMoney, "amountMoney must not be null");
            return this;
        }

        @Override
        public _FinalStage externalDetails(DestinationDetailsExternalRefundDetails externalDetails) {
            this.externalDetails = Optional.ofNullable(externalDetails);
            return this;
        }

        @Override
        @JsonSetter(value="external_details", nulls=Nulls.SKIP)
        public _FinalStage externalDetails(Optional<DestinationDetailsExternalRefundDetails> externalDetails) {
            this.externalDetails = externalDetails;
            return this;
        }

        @Override
        public _FinalStage cashDetails(DestinationDetailsCashRefundDetails cashDetails) {
            this.cashDetails = Optional.ofNullable(cashDetails);
            return this;
        }

        @Override
        @JsonSetter(value="cash_details", nulls=Nulls.SKIP)
        public _FinalStage cashDetails(Optional<DestinationDetailsCashRefundDetails> cashDetails) {
            this.cashDetails = cashDetails;
            return this;
        }

        @Override
        public _FinalStage teamMemberId(Nullable<String> teamMemberId) {
            this.teamMemberId = teamMemberId.isNull() ? null : (teamMemberId.isEmpty() ? Optional.empty() : Optional.of(teamMemberId.get()));
            return this;
        }

        @Override
        public _FinalStage teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        @Override
        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public _FinalStage teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        @Override
        public _FinalStage paymentVersionToken(Nullable<String> paymentVersionToken) {
            this.paymentVersionToken = paymentVersionToken.isNull() ? null : (paymentVersionToken.isEmpty() ? Optional.empty() : Optional.of(paymentVersionToken.get()));
            return this;
        }

        @Override
        public _FinalStage paymentVersionToken(String paymentVersionToken) {
            this.paymentVersionToken = Optional.ofNullable(paymentVersionToken);
            return this;
        }

        @Override
        @JsonSetter(value="payment_version_token", nulls=Nulls.SKIP)
        public _FinalStage paymentVersionToken(Optional<String> paymentVersionToken) {
            this.paymentVersionToken = paymentVersionToken;
            return this;
        }

        @Override
        public _FinalStage reason(Nullable<String> reason) {
            this.reason = reason.isNull() ? null : (reason.isEmpty() ? Optional.empty() : Optional.of(reason.get()));
            return this;
        }

        @Override
        public _FinalStage reason(String reason) {
            this.reason = Optional.ofNullable(reason);
            return this;
        }

        @Override
        @JsonSetter(value="reason", nulls=Nulls.SKIP)
        public _FinalStage reason(Optional<String> reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public _FinalStage customerId(Nullable<String> customerId) {
            this.customerId = customerId.isNull() ? null : (customerId.isEmpty() ? Optional.empty() : Optional.of(customerId.get()));
            return this;
        }

        @Override
        public _FinalStage customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        @Override
        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public _FinalStage customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        @Override
        public _FinalStage locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @Override
        public _FinalStage locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @Override
        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public _FinalStage locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        @Override
        public _FinalStage unlinked(Nullable<Boolean> unlinked) {
            this.unlinked = unlinked.isNull() ? null : (unlinked.isEmpty() ? Optional.empty() : Optional.of(unlinked.get()));
            return this;
        }

        @Override
        public _FinalStage unlinked(Boolean unlinked) {
            this.unlinked = Optional.ofNullable(unlinked);
            return this;
        }

        @Override
        @JsonSetter(value="unlinked", nulls=Nulls.SKIP)
        public _FinalStage unlinked(Optional<Boolean> unlinked) {
            this.unlinked = unlinked;
            return this;
        }

        @Override
        public _FinalStage destinationId(Nullable<String> destinationId) {
            this.destinationId = destinationId.isNull() ? null : (destinationId.isEmpty() ? Optional.empty() : Optional.of(destinationId.get()));
            return this;
        }

        @Override
        public _FinalStage destinationId(String destinationId) {
            this.destinationId = Optional.ofNullable(destinationId);
            return this;
        }

        @Override
        @JsonSetter(value="destination_id", nulls=Nulls.SKIP)
        public _FinalStage destinationId(Optional<String> destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        @Override
        public _FinalStage paymentId(Nullable<String> paymentId) {
            this.paymentId = paymentId.isNull() ? null : (paymentId.isEmpty() ? Optional.empty() : Optional.of(paymentId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentId(String paymentId) {
            this.paymentId = Optional.ofNullable(paymentId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_id", nulls=Nulls.SKIP)
        public _FinalStage paymentId(Optional<String> paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        @Override
        public _FinalStage appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = Optional.ofNullable(appFeeMoney);
            return this;
        }

        @Override
        @JsonSetter(value="app_fee_money", nulls=Nulls.SKIP)
        public _FinalStage appFeeMoney(Optional<Money> appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        @Override
        public RefundPaymentRequest build() {
            return new RefundPaymentRequest(this.idempotencyKey, this.amountMoney, this.appFeeMoney, this.paymentId, this.destinationId, this.unlinked, this.locationId, this.customerId, this.reason, this.paymentVersionToken, this.teamMemberId, this.cashDetails, this.externalDetails, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RefundPaymentRequest build();

        public _FinalStage appFeeMoney(Optional<Money> var1);

        public _FinalStage appFeeMoney(Money var1);

        public _FinalStage paymentId(Optional<String> var1);

        public _FinalStage paymentId(String var1);

        public _FinalStage paymentId(Nullable<String> var1);

        public _FinalStage destinationId(Optional<String> var1);

        public _FinalStage destinationId(String var1);

        public _FinalStage destinationId(Nullable<String> var1);

        public _FinalStage unlinked(Optional<Boolean> var1);

        public _FinalStage unlinked(Boolean var1);

        public _FinalStage unlinked(Nullable<Boolean> var1);

        public _FinalStage locationId(Optional<String> var1);

        public _FinalStage locationId(String var1);

        public _FinalStage locationId(Nullable<String> var1);

        public _FinalStage customerId(Optional<String> var1);

        public _FinalStage customerId(String var1);

        public _FinalStage customerId(Nullable<String> var1);

        public _FinalStage reason(Optional<String> var1);

        public _FinalStage reason(String var1);

        public _FinalStage reason(Nullable<String> var1);

        public _FinalStage paymentVersionToken(Optional<String> var1);

        public _FinalStage paymentVersionToken(String var1);

        public _FinalStage paymentVersionToken(Nullable<String> var1);

        public _FinalStage teamMemberId(Optional<String> var1);

        public _FinalStage teamMemberId(String var1);

        public _FinalStage teamMemberId(Nullable<String> var1);

        public _FinalStage cashDetails(Optional<DestinationDetailsCashRefundDetails> var1);

        public _FinalStage cashDetails(DestinationDetailsCashRefundDetails var1);

        public _FinalStage externalDetails(Optional<DestinationDetailsExternalRefundDetails> var1);

        public _FinalStage externalDetails(DestinationDetailsExternalRefundDetails var1);
    }

    public static interface AmountMoneyStage {
        public _FinalStage amountMoney(@NotNull Money var1);
    }

    public static interface IdempotencyKeyStage {
        public AmountMoneyStage idempotencyKey(@NotNull String var1);

        public Builder from(RefundPaymentRequest var1);
    }
}

