/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RetrieveTokenStatusResponse {
    private final Optional<List<String>> scopes;
    private final Optional<String> expiresAt;
    private final Optional<String> clientId;
    private final Optional<String> merchantId;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private RetrieveTokenStatusResponse(Optional<List<String>> scopes, Optional<String> expiresAt, Optional<String> clientId, Optional<String> merchantId, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.scopes = scopes;
        this.expiresAt = expiresAt;
        this.clientId = clientId;
        this.merchantId = merchantId;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="scopes")
    public Optional<List<String>> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="expires_at")
    public Optional<String> getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="client_id")
    public Optional<String> getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="merchant_id")
    public Optional<String> getMerchantId() {
        return this.merchantId;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RetrieveTokenStatusResponse && this.equalTo((RetrieveTokenStatusResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RetrieveTokenStatusResponse other) {
        return this.scopes.equals(other.scopes) && this.expiresAt.equals(other.expiresAt) && this.clientId.equals(other.clientId) && this.merchantId.equals(other.merchantId) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.scopes, this.expiresAt, this.clientId, this.merchantId, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> scopes = Optional.empty();
        private Optional<String> expiresAt = Optional.empty();
        private Optional<String> clientId = Optional.empty();
        private Optional<String> merchantId = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RetrieveTokenStatusResponse other) {
            this.scopes(other.getScopes());
            this.expiresAt(other.getExpiresAt());
            this.clientId(other.getClientId());
            this.merchantId(other.getMerchantId());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="scopes", nulls=Nulls.SKIP)
        public Builder scopes(Optional<List<String>> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder scopes(List<String> scopes) {
            this.scopes = Optional.ofNullable(scopes);
            return this;
        }

        @JsonSetter(value="expires_at", nulls=Nulls.SKIP)
        public Builder expiresAt(Optional<String> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder expiresAt(String expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        @JsonSetter(value="client_id", nulls=Nulls.SKIP)
        public Builder clientId(Optional<String> clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = Optional.ofNullable(clientId);
            return this;
        }

        @JsonSetter(value="merchant_id", nulls=Nulls.SKIP)
        public Builder merchantId(Optional<String> merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = Optional.ofNullable(merchantId);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public RetrieveTokenStatusResponse build() {
            return new RetrieveTokenStatusResponse(this.scopes, this.expiresAt, this.clientId, this.merchantId, this.errors, this.additionalProperties);
        }
    }
}

