/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RevokeTokenRequest {
    private final Optional<String> clientId;
    private final Optional<String> accessToken;
    private final Optional<String> merchantId;
    private final Optional<Boolean> revokeOnlyAccessToken;
    private final Map<String, Object> additionalProperties;

    private RevokeTokenRequest(Optional<String> clientId, Optional<String> accessToken, Optional<String> merchantId, Optional<Boolean> revokeOnlyAccessToken, Map<String, Object> additionalProperties) {
        this.clientId = clientId;
        this.accessToken = accessToken;
        this.merchantId = merchantId;
        this.revokeOnlyAccessToken = revokeOnlyAccessToken;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getClientId() {
        if (this.clientId == null) {
            return Optional.empty();
        }
        return this.clientId;
    }

    @JsonIgnore
    public Optional<String> getAccessToken() {
        if (this.accessToken == null) {
            return Optional.empty();
        }
        return this.accessToken;
    }

    @JsonIgnore
    public Optional<String> getMerchantId() {
        if (this.merchantId == null) {
            return Optional.empty();
        }
        return this.merchantId;
    }

    @JsonIgnore
    public Optional<Boolean> getRevokeOnlyAccessToken() {
        if (this.revokeOnlyAccessToken == null) {
            return Optional.empty();
        }
        return this.revokeOnlyAccessToken;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="client_id")
    private Optional<String> _getClientId() {
        return this.clientId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="access_token")
    private Optional<String> _getAccessToken() {
        return this.accessToken;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="merchant_id")
    private Optional<String> _getMerchantId() {
        return this.merchantId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="revoke_only_access_token")
    private Optional<Boolean> _getRevokeOnlyAccessToken() {
        return this.revokeOnlyAccessToken;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RevokeTokenRequest && this.equalTo((RevokeTokenRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RevokeTokenRequest other) {
        return this.clientId.equals(other.clientId) && this.accessToken.equals(other.accessToken) && this.merchantId.equals(other.merchantId) && this.revokeOnlyAccessToken.equals(other.revokeOnlyAccessToken);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.accessToken, this.merchantId, this.revokeOnlyAccessToken);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> clientId = Optional.empty();
        private Optional<String> accessToken = Optional.empty();
        private Optional<String> merchantId = Optional.empty();
        private Optional<Boolean> revokeOnlyAccessToken = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RevokeTokenRequest other) {
            this.clientId(other.getClientId());
            this.accessToken(other.getAccessToken());
            this.merchantId(other.getMerchantId());
            this.revokeOnlyAccessToken(other.getRevokeOnlyAccessToken());
            return this;
        }

        @JsonSetter(value="client_id", nulls=Nulls.SKIP)
        public Builder clientId(Optional<String> clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = Optional.ofNullable(clientId);
            return this;
        }

        public Builder clientId(Nullable<String> clientId) {
            this.clientId = clientId.isNull() ? null : (clientId.isEmpty() ? Optional.empty() : Optional.of(clientId.get()));
            return this;
        }

        @JsonSetter(value="access_token", nulls=Nulls.SKIP)
        public Builder accessToken(Optional<String> accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = Optional.ofNullable(accessToken);
            return this;
        }

        public Builder accessToken(Nullable<String> accessToken) {
            this.accessToken = accessToken.isNull() ? null : (accessToken.isEmpty() ? Optional.empty() : Optional.of(accessToken.get()));
            return this;
        }

        @JsonSetter(value="merchant_id", nulls=Nulls.SKIP)
        public Builder merchantId(Optional<String> merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = Optional.ofNullable(merchantId);
            return this;
        }

        public Builder merchantId(Nullable<String> merchantId) {
            this.merchantId = merchantId.isNull() ? null : (merchantId.isEmpty() ? Optional.empty() : Optional.of(merchantId.get()));
            return this;
        }

        @JsonSetter(value="revoke_only_access_token", nulls=Nulls.SKIP)
        public Builder revokeOnlyAccessToken(Optional<Boolean> revokeOnlyAccessToken) {
            this.revokeOnlyAccessToken = revokeOnlyAccessToken;
            return this;
        }

        public Builder revokeOnlyAccessToken(Boolean revokeOnlyAccessToken) {
            this.revokeOnlyAccessToken = Optional.ofNullable(revokeOnlyAccessToken);
            return this;
        }

        public Builder revokeOnlyAccessToken(Nullable<Boolean> revokeOnlyAccessToken) {
            this.revokeOnlyAccessToken = revokeOnlyAccessToken.isNull() ? null : (revokeOnlyAccessToken.isEmpty() ? Optional.empty() : Optional.of(revokeOnlyAccessToken.get()));
            return this;
        }

        public RevokeTokenRequest build() {
            return new RevokeTokenRequest(this.clientId, this.accessToken, this.merchantId, this.revokeOnlyAccessToken, this.additionalProperties);
        }
    }
}

