/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ScheduledShiftDetails;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ScheduledShift {
    private final Optional<String> id;
    private final Optional<ScheduledShiftDetails> draftShiftDetails;
    private final Optional<ScheduledShiftDetails> publishedShiftDetails;
    private final Optional<Integer> version;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Map<String, Object> additionalProperties;

    private ScheduledShift(Optional<String> id, Optional<ScheduledShiftDetails> draftShiftDetails, Optional<ScheduledShiftDetails> publishedShiftDetails, Optional<Integer> version, Optional<String> createdAt, Optional<String> updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.draftShiftDetails = draftShiftDetails;
        this.publishedShiftDetails = publishedShiftDetails;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="draft_shift_details")
    public Optional<ScheduledShiftDetails> getDraftShiftDetails() {
        return this.draftShiftDetails;
    }

    @JsonProperty(value="published_shift_details")
    public Optional<ScheduledShiftDetails> getPublishedShiftDetails() {
        return this.publishedShiftDetails;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScheduledShift && this.equalTo((ScheduledShift)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScheduledShift other) {
        return this.id.equals(other.id) && this.draftShiftDetails.equals(other.draftShiftDetails) && this.publishedShiftDetails.equals(other.publishedShiftDetails) && this.version.equals(other.version) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.draftShiftDetails, this.publishedShiftDetails, this.version, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<ScheduledShiftDetails> draftShiftDetails = Optional.empty();
        private Optional<ScheduledShiftDetails> publishedShiftDetails = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ScheduledShift other) {
            this.id(other.getId());
            this.draftShiftDetails(other.getDraftShiftDetails());
            this.publishedShiftDetails(other.getPublishedShiftDetails());
            this.version(other.getVersion());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="draft_shift_details", nulls=Nulls.SKIP)
        public Builder draftShiftDetails(Optional<ScheduledShiftDetails> draftShiftDetails) {
            this.draftShiftDetails = draftShiftDetails;
            return this;
        }

        public Builder draftShiftDetails(ScheduledShiftDetails draftShiftDetails) {
            this.draftShiftDetails = Optional.ofNullable(draftShiftDetails);
            return this;
        }

        @JsonSetter(value="published_shift_details", nulls=Nulls.SKIP)
        public Builder publishedShiftDetails(Optional<ScheduledShiftDetails> publishedShiftDetails) {
            this.publishedShiftDetails = publishedShiftDetails;
            return this;
        }

        public Builder publishedShiftDetails(ScheduledShiftDetails publishedShiftDetails) {
            this.publishedShiftDetails = Optional.ofNullable(publishedShiftDetails);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        public Builder version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public ScheduledShift build() {
            return new ScheduledShift(this.id, this.draftShiftDetails, this.publishedShiftDetails, this.version, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }
}

