/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ScheduledShiftDetails {
    private final Optional<String> teamMemberId;
    private final Optional<String> locationId;
    private final Optional<String> jobId;
    private final Optional<String> startAt;
    private final Optional<String> endAt;
    private final Optional<String> notes;
    private final Optional<Boolean> isDeleted;
    private final Optional<String> timezone;
    private final Map<String, Object> additionalProperties;

    private ScheduledShiftDetails(Optional<String> teamMemberId, Optional<String> locationId, Optional<String> jobId, Optional<String> startAt, Optional<String> endAt, Optional<String> notes, Optional<Boolean> isDeleted, Optional<String> timezone, Map<String, Object> additionalProperties) {
        this.teamMemberId = teamMemberId;
        this.locationId = locationId;
        this.jobId = jobId;
        this.startAt = startAt;
        this.endAt = endAt;
        this.notes = notes;
        this.isDeleted = isDeleted;
        this.timezone = timezone;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getTeamMemberId() {
        if (this.teamMemberId == null) {
            return Optional.empty();
        }
        return this.teamMemberId;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getJobId() {
        if (this.jobId == null) {
            return Optional.empty();
        }
        return this.jobId;
    }

    @JsonIgnore
    public Optional<String> getStartAt() {
        if (this.startAt == null) {
            return Optional.empty();
        }
        return this.startAt;
    }

    @JsonIgnore
    public Optional<String> getEndAt() {
        if (this.endAt == null) {
            return Optional.empty();
        }
        return this.endAt;
    }

    @JsonIgnore
    public Optional<String> getNotes() {
        if (this.notes == null) {
            return Optional.empty();
        }
        return this.notes;
    }

    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        if (this.isDeleted == null) {
            return Optional.empty();
        }
        return this.isDeleted;
    }

    @JsonProperty(value="timezone")
    public Optional<String> getTimezone() {
        return this.timezone;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_id")
    private Optional<String> _getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="job_id")
    private Optional<String> _getJobId() {
        return this.jobId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="start_at")
    private Optional<String> _getStartAt() {
        return this.startAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="end_at")
    private Optional<String> _getEndAt() {
        return this.endAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="notes")
    private Optional<String> _getNotes() {
        return this.notes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_deleted")
    private Optional<Boolean> _getIsDeleted() {
        return this.isDeleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScheduledShiftDetails && this.equalTo((ScheduledShiftDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScheduledShiftDetails other) {
        return this.teamMemberId.equals(other.teamMemberId) && this.locationId.equals(other.locationId) && this.jobId.equals(other.jobId) && this.startAt.equals(other.startAt) && this.endAt.equals(other.endAt) && this.notes.equals(other.notes) && this.isDeleted.equals(other.isDeleted) && this.timezone.equals(other.timezone);
    }

    public int hashCode() {
        return Objects.hash(this.teamMemberId, this.locationId, this.jobId, this.startAt, this.endAt, this.notes, this.isDeleted, this.timezone);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> jobId = Optional.empty();
        private Optional<String> startAt = Optional.empty();
        private Optional<String> endAt = Optional.empty();
        private Optional<String> notes = Optional.empty();
        private Optional<Boolean> isDeleted = Optional.empty();
        private Optional<String> timezone = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ScheduledShiftDetails other) {
            this.teamMemberId(other.getTeamMemberId());
            this.locationId(other.getLocationId());
            this.jobId(other.getJobId());
            this.startAt(other.getStartAt());
            this.endAt(other.getEndAt());
            this.notes(other.getNotes());
            this.isDeleted(other.getIsDeleted());
            this.timezone(other.getTimezone());
            return this;
        }

        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public Builder teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        public Builder teamMemberId(Nullable<String> teamMemberId) {
            this.teamMemberId = teamMemberId.isNull() ? null : (teamMemberId.isEmpty() ? Optional.empty() : Optional.of(teamMemberId.get()));
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="job_id", nulls=Nulls.SKIP)
        public Builder jobId(Optional<String> jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = Optional.ofNullable(jobId);
            return this;
        }

        public Builder jobId(Nullable<String> jobId) {
            this.jobId = jobId.isNull() ? null : (jobId.isEmpty() ? Optional.empty() : Optional.of(jobId.get()));
            return this;
        }

        @JsonSetter(value="start_at", nulls=Nulls.SKIP)
        public Builder startAt(Optional<String> startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder startAt(String startAt) {
            this.startAt = Optional.ofNullable(startAt);
            return this;
        }

        public Builder startAt(Nullable<String> startAt) {
            this.startAt = startAt.isNull() ? null : (startAt.isEmpty() ? Optional.empty() : Optional.of(startAt.get()));
            return this;
        }

        @JsonSetter(value="end_at", nulls=Nulls.SKIP)
        public Builder endAt(Optional<String> endAt) {
            this.endAt = endAt;
            return this;
        }

        public Builder endAt(String endAt) {
            this.endAt = Optional.ofNullable(endAt);
            return this;
        }

        public Builder endAt(Nullable<String> endAt) {
            this.endAt = endAt.isNull() ? null : (endAt.isEmpty() ? Optional.empty() : Optional.of(endAt.get()));
            return this;
        }

        @JsonSetter(value="notes", nulls=Nulls.SKIP)
        public Builder notes(Optional<String> notes) {
            this.notes = notes;
            return this;
        }

        public Builder notes(String notes) {
            this.notes = Optional.ofNullable(notes);
            return this;
        }

        public Builder notes(Nullable<String> notes) {
            this.notes = notes.isNull() ? null : (notes.isEmpty() ? Optional.empty() : Optional.of(notes.get()));
            return this;
        }

        @JsonSetter(value="is_deleted", nulls=Nulls.SKIP)
        public Builder isDeleted(Optional<Boolean> isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = Optional.ofNullable(isDeleted);
            return this;
        }

        public Builder isDeleted(Nullable<Boolean> isDeleted) {
            this.isDeleted = isDeleted.isNull() ? null : (isDeleted.isEmpty() ? Optional.empty() : Optional.of(isDeleted.get()));
            return this;
        }

        @JsonSetter(value="timezone", nulls=Nulls.SKIP)
        public Builder timezone(Optional<String> timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = Optional.ofNullable(timezone);
            return this;
        }

        public ScheduledShiftDetails build() {
            return new ScheduledShiftDetails(this.teamMemberId, this.locationId, this.jobId, this.startAt, this.endAt, this.notes, this.isDeleted, this.timezone, this.additionalProperties);
        }
    }
}

