/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ScheduledShiftFilterAssignmentStatus;
import com.squareup.square.types.ScheduledShiftFilterScheduledShiftStatus;
import com.squareup.square.types.ScheduledShiftWorkday;
import com.squareup.square.types.TimeRange;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ScheduledShiftFilter {
    private final Optional<List<String>> locationIds;
    private final Optional<TimeRange> start;
    private final Optional<TimeRange> end;
    private final Optional<ScheduledShiftWorkday> workday;
    private final Optional<List<String>> teamMemberIds;
    private final Optional<ScheduledShiftFilterAssignmentStatus> assignmentStatus;
    private final Optional<List<ScheduledShiftFilterScheduledShiftStatus>> scheduledShiftStatuses;
    private final Map<String, Object> additionalProperties;

    private ScheduledShiftFilter(Optional<List<String>> locationIds, Optional<TimeRange> start, Optional<TimeRange> end, Optional<ScheduledShiftWorkday> workday, Optional<List<String>> teamMemberIds, Optional<ScheduledShiftFilterAssignmentStatus> assignmentStatus, Optional<List<ScheduledShiftFilterScheduledShiftStatus>> scheduledShiftStatuses, Map<String, Object> additionalProperties) {
        this.locationIds = locationIds;
        this.start = start;
        this.end = end;
        this.workday = workday;
        this.teamMemberIds = teamMemberIds;
        this.assignmentStatus = assignmentStatus;
        this.scheduledShiftStatuses = scheduledShiftStatuses;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<String>> getLocationIds() {
        if (this.locationIds == null) {
            return Optional.empty();
        }
        return this.locationIds;
    }

    @JsonProperty(value="start")
    public Optional<TimeRange> getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public Optional<TimeRange> getEnd() {
        return this.end;
    }

    @JsonProperty(value="workday")
    public Optional<ScheduledShiftWorkday> getWorkday() {
        return this.workday;
    }

    @JsonIgnore
    public Optional<List<String>> getTeamMemberIds() {
        if (this.teamMemberIds == null) {
            return Optional.empty();
        }
        return this.teamMemberIds;
    }

    @JsonProperty(value="assignment_status")
    public Optional<ScheduledShiftFilterAssignmentStatus> getAssignmentStatus() {
        return this.assignmentStatus;
    }

    @JsonIgnore
    public Optional<List<ScheduledShiftFilterScheduledShiftStatus>> getScheduledShiftStatuses() {
        if (this.scheduledShiftStatuses == null) {
            return Optional.empty();
        }
        return this.scheduledShiftStatuses;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_ids")
    private Optional<List<String>> _getLocationIds() {
        return this.locationIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_ids")
    private Optional<List<String>> _getTeamMemberIds() {
        return this.teamMemberIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="scheduled_shift_statuses")
    private Optional<List<ScheduledShiftFilterScheduledShiftStatus>> _getScheduledShiftStatuses() {
        return this.scheduledShiftStatuses;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScheduledShiftFilter && this.equalTo((ScheduledShiftFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScheduledShiftFilter other) {
        return this.locationIds.equals(other.locationIds) && this.start.equals(other.start) && this.end.equals(other.end) && this.workday.equals(other.workday) && this.teamMemberIds.equals(other.teamMemberIds) && this.assignmentStatus.equals(other.assignmentStatus) && this.scheduledShiftStatuses.equals(other.scheduledShiftStatuses);
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.start, this.end, this.workday, this.teamMemberIds, this.assignmentStatus, this.scheduledShiftStatuses);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> locationIds = Optional.empty();
        private Optional<TimeRange> start = Optional.empty();
        private Optional<TimeRange> end = Optional.empty();
        private Optional<ScheduledShiftWorkday> workday = Optional.empty();
        private Optional<List<String>> teamMemberIds = Optional.empty();
        private Optional<ScheduledShiftFilterAssignmentStatus> assignmentStatus = Optional.empty();
        private Optional<List<ScheduledShiftFilterScheduledShiftStatus>> scheduledShiftStatuses = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ScheduledShiftFilter other) {
            this.locationIds(other.getLocationIds());
            this.start(other.getStart());
            this.end(other.getEnd());
            this.workday(other.getWorkday());
            this.teamMemberIds(other.getTeamMemberIds());
            this.assignmentStatus(other.getAssignmentStatus());
            this.scheduledShiftStatuses(other.getScheduledShiftStatuses());
            return this;
        }

        @JsonSetter(value="location_ids", nulls=Nulls.SKIP)
        public Builder locationIds(Optional<List<String>> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = Optional.ofNullable(locationIds);
            return this;
        }

        public Builder locationIds(Nullable<List<String>> locationIds) {
            this.locationIds = locationIds.isNull() ? null : (locationIds.isEmpty() ? Optional.empty() : Optional.of(locationIds.get()));
            return this;
        }

        @JsonSetter(value="start", nulls=Nulls.SKIP)
        public Builder start(Optional<TimeRange> start) {
            this.start = start;
            return this;
        }

        public Builder start(TimeRange start) {
            this.start = Optional.ofNullable(start);
            return this;
        }

        @JsonSetter(value="end", nulls=Nulls.SKIP)
        public Builder end(Optional<TimeRange> end) {
            this.end = end;
            return this;
        }

        public Builder end(TimeRange end) {
            this.end = Optional.ofNullable(end);
            return this;
        }

        @JsonSetter(value="workday", nulls=Nulls.SKIP)
        public Builder workday(Optional<ScheduledShiftWorkday> workday) {
            this.workday = workday;
            return this;
        }

        public Builder workday(ScheduledShiftWorkday workday) {
            this.workday = Optional.ofNullable(workday);
            return this;
        }

        @JsonSetter(value="team_member_ids", nulls=Nulls.SKIP)
        public Builder teamMemberIds(Optional<List<String>> teamMemberIds) {
            this.teamMemberIds = teamMemberIds;
            return this;
        }

        public Builder teamMemberIds(List<String> teamMemberIds) {
            this.teamMemberIds = Optional.ofNullable(teamMemberIds);
            return this;
        }

        public Builder teamMemberIds(Nullable<List<String>> teamMemberIds) {
            this.teamMemberIds = teamMemberIds.isNull() ? null : (teamMemberIds.isEmpty() ? Optional.empty() : Optional.of(teamMemberIds.get()));
            return this;
        }

        @JsonSetter(value="assignment_status", nulls=Nulls.SKIP)
        public Builder assignmentStatus(Optional<ScheduledShiftFilterAssignmentStatus> assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        public Builder assignmentStatus(ScheduledShiftFilterAssignmentStatus assignmentStatus) {
            this.assignmentStatus = Optional.ofNullable(assignmentStatus);
            return this;
        }

        @JsonSetter(value="scheduled_shift_statuses", nulls=Nulls.SKIP)
        public Builder scheduledShiftStatuses(Optional<List<ScheduledShiftFilterScheduledShiftStatus>> scheduledShiftStatuses) {
            this.scheduledShiftStatuses = scheduledShiftStatuses;
            return this;
        }

        public Builder scheduledShiftStatuses(List<ScheduledShiftFilterScheduledShiftStatus> scheduledShiftStatuses) {
            this.scheduledShiftStatuses = Optional.ofNullable(scheduledShiftStatuses);
            return this;
        }

        public Builder scheduledShiftStatuses(Nullable<List<ScheduledShiftFilterScheduledShiftStatus>> scheduledShiftStatuses) {
            this.scheduledShiftStatuses = scheduledShiftStatuses.isNull() ? null : (scheduledShiftStatuses.isEmpty() ? Optional.empty() : Optional.of(scheduledShiftStatuses.get()));
            return this;
        }

        public ScheduledShiftFilter build() {
            return new ScheduledShiftFilter(this.locationIds, this.start, this.end, this.workday, this.teamMemberIds, this.assignmentStatus, this.scheduledShiftStatuses, this.additionalProperties);
        }
    }
}

