/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ScheduledShiftFilter;
import com.squareup.square.types.ScheduledShiftSort;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ScheduledShiftQuery {
    private final Optional<ScheduledShiftFilter> filter;
    private final Optional<ScheduledShiftSort> sort;
    private final Map<String, Object> additionalProperties;

    private ScheduledShiftQuery(Optional<ScheduledShiftFilter> filter, Optional<ScheduledShiftSort> sort, Map<String, Object> additionalProperties) {
        this.filter = filter;
        this.sort = sort;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="filter")
    public Optional<ScheduledShiftFilter> getFilter() {
        return this.filter;
    }

    @JsonProperty(value="sort")
    public Optional<ScheduledShiftSort> getSort() {
        return this.sort;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScheduledShiftQuery && this.equalTo((ScheduledShiftQuery)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScheduledShiftQuery other) {
        return this.filter.equals(other.filter) && this.sort.equals(other.sort);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ScheduledShiftFilter> filter = Optional.empty();
        private Optional<ScheduledShiftSort> sort = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ScheduledShiftQuery other) {
            this.filter(other.getFilter());
            this.sort(other.getSort());
            return this;
        }

        @JsonSetter(value="filter", nulls=Nulls.SKIP)
        public Builder filter(Optional<ScheduledShiftFilter> filter) {
            this.filter = filter;
            return this;
        }

        public Builder filter(ScheduledShiftFilter filter) {
            this.filter = Optional.ofNullable(filter);
            return this;
        }

        @JsonSetter(value="sort", nulls=Nulls.SKIP)
        public Builder sort(Optional<ScheduledShiftSort> sort) {
            this.sort = sort;
            return this;
        }

        public Builder sort(ScheduledShiftSort sort) {
            this.sort = Optional.ofNullable(sort);
            return this;
        }

        public ScheduledShiftQuery build() {
            return new ScheduledShiftQuery(this.filter, this.sort, this.additionalProperties);
        }
    }
}

