/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SegmentFilter;
import com.squareup.square.types.TimeRange;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchAvailabilityFilter {
    private final TimeRange startAtRange;
    private final Optional<String> locationId;
    private final Optional<List<SegmentFilter>> segmentFilters;
    private final Optional<String> bookingId;
    private final Map<String, Object> additionalProperties;

    private SearchAvailabilityFilter(TimeRange startAtRange, Optional<String> locationId, Optional<List<SegmentFilter>> segmentFilters, Optional<String> bookingId, Map<String, Object> additionalProperties) {
        this.startAtRange = startAtRange;
        this.locationId = locationId;
        this.segmentFilters = segmentFilters;
        this.bookingId = bookingId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="start_at_range")
    public TimeRange getStartAtRange() {
        return this.startAtRange;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<List<SegmentFilter>> getSegmentFilters() {
        if (this.segmentFilters == null) {
            return Optional.empty();
        }
        return this.segmentFilters;
    }

    @JsonIgnore
    public Optional<String> getBookingId() {
        if (this.bookingId == null) {
            return Optional.empty();
        }
        return this.bookingId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="segment_filters")
    private Optional<List<SegmentFilter>> _getSegmentFilters() {
        return this.segmentFilters;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="booking_id")
    private Optional<String> _getBookingId() {
        return this.bookingId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchAvailabilityFilter && this.equalTo((SearchAvailabilityFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchAvailabilityFilter other) {
        return this.startAtRange.equals(other.startAtRange) && this.locationId.equals(other.locationId) && this.segmentFilters.equals(other.segmentFilters) && this.bookingId.equals(other.bookingId);
    }

    public int hashCode() {
        return Objects.hash(this.startAtRange, this.locationId, this.segmentFilters, this.bookingId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StartAtRangeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements StartAtRangeStage,
    _FinalStage {
        private TimeRange startAtRange;
        private Optional<String> bookingId = Optional.empty();
        private Optional<List<SegmentFilter>> segmentFilters = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SearchAvailabilityFilter other) {
            this.startAtRange(other.getStartAtRange());
            this.locationId(other.getLocationId());
            this.segmentFilters(other.getSegmentFilters());
            this.bookingId(other.getBookingId());
            return this;
        }

        @Override
        @JsonSetter(value="start_at_range")
        public _FinalStage startAtRange(@NotNull TimeRange startAtRange) {
            this.startAtRange = Objects.requireNonNull(startAtRange, "startAtRange must not be null");
            return this;
        }

        @Override
        public _FinalStage bookingId(Nullable<String> bookingId) {
            this.bookingId = bookingId.isNull() ? null : (bookingId.isEmpty() ? Optional.empty() : Optional.of(bookingId.get()));
            return this;
        }

        @Override
        public _FinalStage bookingId(String bookingId) {
            this.bookingId = Optional.ofNullable(bookingId);
            return this;
        }

        @Override
        @JsonSetter(value="booking_id", nulls=Nulls.SKIP)
        public _FinalStage bookingId(Optional<String> bookingId) {
            this.bookingId = bookingId;
            return this;
        }

        @Override
        public _FinalStage segmentFilters(Nullable<List<SegmentFilter>> segmentFilters) {
            this.segmentFilters = segmentFilters.isNull() ? null : (segmentFilters.isEmpty() ? Optional.empty() : Optional.of(segmentFilters.get()));
            return this;
        }

        @Override
        public _FinalStage segmentFilters(List<SegmentFilter> segmentFilters) {
            this.segmentFilters = Optional.ofNullable(segmentFilters);
            return this;
        }

        @Override
        @JsonSetter(value="segment_filters", nulls=Nulls.SKIP)
        public _FinalStage segmentFilters(Optional<List<SegmentFilter>> segmentFilters) {
            this.segmentFilters = segmentFilters;
            return this;
        }

        @Override
        public _FinalStage locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @Override
        public _FinalStage locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @Override
        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public _FinalStage locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        @Override
        public SearchAvailabilityFilter build() {
            return new SearchAvailabilityFilter(this.startAtRange, this.locationId, this.segmentFilters, this.bookingId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SearchAvailabilityFilter build();

        public _FinalStage locationId(Optional<String> var1);

        public _FinalStage locationId(String var1);

        public _FinalStage locationId(Nullable<String> var1);

        public _FinalStage segmentFilters(Optional<List<SegmentFilter>> var1);

        public _FinalStage segmentFilters(List<SegmentFilter> var1);

        public _FinalStage segmentFilters(Nullable<List<SegmentFilter>> var1);

        public _FinalStage bookingId(Optional<String> var1);

        public _FinalStage bookingId(String var1);

        public _FinalStage bookingId(Nullable<String> var1);
    }

    public static interface StartAtRangeStage {
        public _FinalStage startAtRange(@NotNull TimeRange var1);

        public Builder from(SearchAvailabilityFilter var1);
    }
}

