/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchCatalogObjectsResponse {
    private final Optional<List<Error>> errors;
    private final Optional<String> cursor;
    private final Optional<List<CatalogObject>> objects;
    private final Optional<List<CatalogObject>> relatedObjects;
    private final Optional<String> latestTime;
    private final Map<String, Object> additionalProperties;

    private SearchCatalogObjectsResponse(Optional<List<Error>> errors, Optional<String> cursor, Optional<List<CatalogObject>> objects, Optional<List<CatalogObject>> relatedObjects, Optional<String> latestTime, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.cursor = cursor;
        this.objects = objects;
        this.relatedObjects = relatedObjects;
        this.latestTime = latestTime;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="objects")
    public Optional<List<CatalogObject>> getObjects() {
        return this.objects;
    }

    @JsonProperty(value="related_objects")
    public Optional<List<CatalogObject>> getRelatedObjects() {
        return this.relatedObjects;
    }

    @JsonProperty(value="latest_time")
    public Optional<String> getLatestTime() {
        return this.latestTime;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchCatalogObjectsResponse && this.equalTo((SearchCatalogObjectsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchCatalogObjectsResponse other) {
        return this.errors.equals(other.errors) && this.cursor.equals(other.cursor) && this.objects.equals(other.objects) && this.relatedObjects.equals(other.relatedObjects) && this.latestTime.equals(other.latestTime);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.cursor, this.objects, this.relatedObjects, this.latestTime);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<List<CatalogObject>> objects = Optional.empty();
        private Optional<List<CatalogObject>> relatedObjects = Optional.empty();
        private Optional<String> latestTime = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchCatalogObjectsResponse other) {
            this.errors(other.getErrors());
            this.cursor(other.getCursor());
            this.objects(other.getObjects());
            this.relatedObjects(other.getRelatedObjects());
            this.latestTime(other.getLatestTime());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="objects", nulls=Nulls.SKIP)
        public Builder objects(Optional<List<CatalogObject>> objects) {
            this.objects = objects;
            return this;
        }

        public Builder objects(List<CatalogObject> objects) {
            this.objects = Optional.ofNullable(objects);
            return this;
        }

        @JsonSetter(value="related_objects", nulls=Nulls.SKIP)
        public Builder relatedObjects(Optional<List<CatalogObject>> relatedObjects) {
            this.relatedObjects = relatedObjects;
            return this;
        }

        public Builder relatedObjects(List<CatalogObject> relatedObjects) {
            this.relatedObjects = Optional.ofNullable(relatedObjects);
            return this;
        }

        @JsonSetter(value="latest_time", nulls=Nulls.SKIP)
        public Builder latestTime(Optional<String> latestTime) {
            this.latestTime = latestTime;
            return this;
        }

        public Builder latestTime(String latestTime) {
            this.latestTime = Optional.ofNullable(latestTime);
            return this;
        }

        public SearchCatalogObjectsResponse build() {
            return new SearchCatalogObjectsResponse(this.errors, this.cursor, this.objects, this.relatedObjects, this.latestTime, this.additionalProperties);
        }
    }
}

