/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Customer;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchCustomersResponse {
    private final Optional<List<Error>> errors;
    private final Optional<List<Customer>> customers;
    private final Optional<String> cursor;
    private final Optional<Long> count;
    private final Map<String, Object> additionalProperties;

    private SearchCustomersResponse(Optional<List<Error>> errors, Optional<List<Customer>> customers, Optional<String> cursor, Optional<Long> count, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.customers = customers;
        this.cursor = cursor;
        this.count = count;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="customers")
    public Optional<List<Customer>> getCustomers() {
        return this.customers;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="count")
    public Optional<Long> getCount() {
        return this.count;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchCustomersResponse && this.equalTo((SearchCustomersResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchCustomersResponse other) {
        return this.errors.equals(other.errors) && this.customers.equals(other.customers) && this.cursor.equals(other.cursor) && this.count.equals(other.count);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.customers, this.cursor, this.count);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<List<Customer>> customers = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<Long> count = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchCustomersResponse other) {
            this.errors(other.getErrors());
            this.customers(other.getCustomers());
            this.cursor(other.getCursor());
            this.count(other.getCount());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="customers", nulls=Nulls.SKIP)
        public Builder customers(Optional<List<Customer>> customers) {
            this.customers = customers;
            return this;
        }

        public Builder customers(List<Customer> customers) {
            this.customers = Optional.ofNullable(customers);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="count", nulls=Nulls.SKIP)
        public Builder count(Optional<Long> count) {
            this.count = count;
            return this;
        }

        public Builder count(Long count) {
            this.count = Optional.ofNullable(count);
            return this;
        }

        public SearchCustomersResponse build() {
            return new SearchCustomersResponse(this.errors, this.customers, this.cursor, this.count, this.additionalProperties);
        }
    }
}

