/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TimeRange;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchEventsFilter {
    private final Optional<List<String>> eventTypes;
    private final Optional<List<String>> merchantIds;
    private final Optional<List<String>> locationIds;
    private final Optional<TimeRange> createdAt;
    private final Map<String, Object> additionalProperties;

    private SearchEventsFilter(Optional<List<String>> eventTypes, Optional<List<String>> merchantIds, Optional<List<String>> locationIds, Optional<TimeRange> createdAt, Map<String, Object> additionalProperties) {
        this.eventTypes = eventTypes;
        this.merchantIds = merchantIds;
        this.locationIds = locationIds;
        this.createdAt = createdAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<String>> getEventTypes() {
        if (this.eventTypes == null) {
            return Optional.empty();
        }
        return this.eventTypes;
    }

    @JsonIgnore
    public Optional<List<String>> getMerchantIds() {
        if (this.merchantIds == null) {
            return Optional.empty();
        }
        return this.merchantIds;
    }

    @JsonIgnore
    public Optional<List<String>> getLocationIds() {
        if (this.locationIds == null) {
            return Optional.empty();
        }
        return this.locationIds;
    }

    @JsonProperty(value="created_at")
    public Optional<TimeRange> getCreatedAt() {
        return this.createdAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="event_types")
    private Optional<List<String>> _getEventTypes() {
        return this.eventTypes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="merchant_ids")
    private Optional<List<String>> _getMerchantIds() {
        return this.merchantIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_ids")
    private Optional<List<String>> _getLocationIds() {
        return this.locationIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchEventsFilter && this.equalTo((SearchEventsFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchEventsFilter other) {
        return this.eventTypes.equals(other.eventTypes) && this.merchantIds.equals(other.merchantIds) && this.locationIds.equals(other.locationIds) && this.createdAt.equals(other.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.eventTypes, this.merchantIds, this.locationIds, this.createdAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> eventTypes = Optional.empty();
        private Optional<List<String>> merchantIds = Optional.empty();
        private Optional<List<String>> locationIds = Optional.empty();
        private Optional<TimeRange> createdAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchEventsFilter other) {
            this.eventTypes(other.getEventTypes());
            this.merchantIds(other.getMerchantIds());
            this.locationIds(other.getLocationIds());
            this.createdAt(other.getCreatedAt());
            return this;
        }

        @JsonSetter(value="event_types", nulls=Nulls.SKIP)
        public Builder eventTypes(Optional<List<String>> eventTypes) {
            this.eventTypes = eventTypes;
            return this;
        }

        public Builder eventTypes(List<String> eventTypes) {
            this.eventTypes = Optional.ofNullable(eventTypes);
            return this;
        }

        public Builder eventTypes(Nullable<List<String>> eventTypes) {
            this.eventTypes = eventTypes.isNull() ? null : (eventTypes.isEmpty() ? Optional.empty() : Optional.of(eventTypes.get()));
            return this;
        }

        @JsonSetter(value="merchant_ids", nulls=Nulls.SKIP)
        public Builder merchantIds(Optional<List<String>> merchantIds) {
            this.merchantIds = merchantIds;
            return this;
        }

        public Builder merchantIds(List<String> merchantIds) {
            this.merchantIds = Optional.ofNullable(merchantIds);
            return this;
        }

        public Builder merchantIds(Nullable<List<String>> merchantIds) {
            this.merchantIds = merchantIds.isNull() ? null : (merchantIds.isEmpty() ? Optional.empty() : Optional.of(merchantIds.get()));
            return this;
        }

        @JsonSetter(value="location_ids", nulls=Nulls.SKIP)
        public Builder locationIds(Optional<List<String>> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = Optional.ofNullable(locationIds);
            return this;
        }

        public Builder locationIds(Nullable<List<String>> locationIds) {
            this.locationIds = locationIds.isNull() ? null : (locationIds.isEmpty() ? Optional.empty() : Optional.of(locationIds.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<TimeRange> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(TimeRange createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        public SearchEventsFilter build() {
            return new SearchEventsFilter(this.eventTypes, this.merchantIds, this.locationIds, this.createdAt, this.additionalProperties);
        }
    }
}

