/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SearchEventsFilter;
import com.squareup.square.types.SearchEventsSort;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchEventsQuery {
    private final Optional<SearchEventsFilter> filter;
    private final Optional<SearchEventsSort> sort;
    private final Map<String, Object> additionalProperties;

    private SearchEventsQuery(Optional<SearchEventsFilter> filter, Optional<SearchEventsSort> sort, Map<String, Object> additionalProperties) {
        this.filter = filter;
        this.sort = sort;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="filter")
    public Optional<SearchEventsFilter> getFilter() {
        return this.filter;
    }

    @JsonProperty(value="sort")
    public Optional<SearchEventsSort> getSort() {
        return this.sort;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchEventsQuery && this.equalTo((SearchEventsQuery)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchEventsQuery other) {
        return this.filter.equals(other.filter) && this.sort.equals(other.sort);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<SearchEventsFilter> filter = Optional.empty();
        private Optional<SearchEventsSort> sort = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchEventsQuery other) {
            this.filter(other.getFilter());
            this.sort(other.getSort());
            return this;
        }

        @JsonSetter(value="filter", nulls=Nulls.SKIP)
        public Builder filter(Optional<SearchEventsFilter> filter) {
            this.filter = filter;
            return this;
        }

        public Builder filter(SearchEventsFilter filter) {
            this.filter = Optional.ofNullable(filter);
            return this;
        }

        @JsonSetter(value="sort", nulls=Nulls.SKIP)
        public Builder sort(Optional<SearchEventsSort> sort) {
            this.sort = sort;
            return this;
        }

        public Builder sort(SearchEventsSort sort) {
            this.sort = Optional.ofNullable(sort);
            return this;
        }

        public SearchEventsQuery build() {
            return new SearchEventsQuery(this.filter, this.sort, this.additionalProperties);
        }
    }
}

