/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SearchEventsQuery;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchEventsRequest {
    private final Optional<String> cursor;
    private final Optional<Integer> limit;
    private final Optional<SearchEventsQuery> query;
    private final Map<String, Object> additionalProperties;

    private SearchEventsRequest(Optional<String> cursor, Optional<Integer> limit, Optional<SearchEventsQuery> query, Map<String, Object> additionalProperties) {
        this.cursor = cursor;
        this.limit = limit;
        this.query = query;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="query")
    public Optional<SearchEventsQuery> getQuery() {
        return this.query;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchEventsRequest && this.equalTo((SearchEventsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchEventsRequest other) {
        return this.cursor.equals(other.cursor) && this.limit.equals(other.limit) && this.query.equals(other.query);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit, this.query);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> cursor = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<SearchEventsQuery> query = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchEventsRequest other) {
            this.cursor(other.getCursor());
            this.limit(other.getLimit());
            this.query(other.getQuery());
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="query", nulls=Nulls.SKIP)
        public Builder query(Optional<SearchEventsQuery> query) {
            this.query = query;
            return this;
        }

        public Builder query(SearchEventsQuery query) {
            this.query = Optional.ofNullable(query);
            return this;
        }

        public SearchEventsRequest build() {
            return new SearchEventsRequest(this.cursor, this.limit, this.query, this.additionalProperties);
        }
    }
}

