/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TimeRange;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchOrdersDateTimeFilter {
    private final Optional<TimeRange> createdAt;
    private final Optional<TimeRange> updatedAt;
    private final Optional<TimeRange> closedAt;
    private final Map<String, Object> additionalProperties;

    private SearchOrdersDateTimeFilter(Optional<TimeRange> createdAt, Optional<TimeRange> updatedAt, Optional<TimeRange> closedAt, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public Optional<TimeRange> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<TimeRange> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="closed_at")
    public Optional<TimeRange> getClosedAt() {
        return this.closedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchOrdersDateTimeFilter && this.equalTo((SearchOrdersDateTimeFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchOrdersDateTimeFilter other) {
        return this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.closedAt.equals(other.closedAt);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.updatedAt, this.closedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<TimeRange> createdAt = Optional.empty();
        private Optional<TimeRange> updatedAt = Optional.empty();
        private Optional<TimeRange> closedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchOrdersDateTimeFilter other) {
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.closedAt(other.getClosedAt());
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<TimeRange> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(TimeRange createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<TimeRange> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(TimeRange updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="closed_at", nulls=Nulls.SKIP)
        public Builder closedAt(Optional<TimeRange> closedAt) {
            this.closedAt = closedAt;
            return this;
        }

        public Builder closedAt(TimeRange closedAt) {
            this.closedAt = Optional.ofNullable(closedAt);
            return this;
        }

        public SearchOrdersDateTimeFilter build() {
            return new SearchOrdersDateTimeFilter(this.createdAt, this.updatedAt, this.closedAt, this.additionalProperties);
        }
    }
}

