/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SearchOrdersSortField;
import com.squareup.square.types.SortOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchOrdersSort {
    private final SearchOrdersSortField sortField;
    private final Optional<SortOrder> sortOrder;
    private final Map<String, Object> additionalProperties;

    private SearchOrdersSort(SearchOrdersSortField sortField, Optional<SortOrder> sortOrder, Map<String, Object> additionalProperties) {
        this.sortField = sortField;
        this.sortOrder = sortOrder;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="sort_field")
    public SearchOrdersSortField getSortField() {
        return this.sortField;
    }

    @JsonProperty(value="sort_order")
    public Optional<SortOrder> getSortOrder() {
        return this.sortOrder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchOrdersSort && this.equalTo((SearchOrdersSort)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchOrdersSort other) {
        return this.sortField.equals(other.sortField) && this.sortOrder.equals(other.sortOrder);
    }

    public int hashCode() {
        return Objects.hash(this.sortField, this.sortOrder);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SortFieldStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SortFieldStage,
    _FinalStage {
        private SearchOrdersSortField sortField;
        private Optional<SortOrder> sortOrder = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SearchOrdersSort other) {
            this.sortField(other.getSortField());
            this.sortOrder(other.getSortOrder());
            return this;
        }

        @Override
        @JsonSetter(value="sort_field")
        public _FinalStage sortField(@NotNull SearchOrdersSortField sortField) {
            this.sortField = Objects.requireNonNull(sortField, "sortField must not be null");
            return this;
        }

        @Override
        public _FinalStage sortOrder(SortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        @Override
        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public _FinalStage sortOrder(Optional<SortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public SearchOrdersSort build() {
            return new SearchOrdersSort(this.sortField, this.sortOrder, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SearchOrdersSort build();

        public _FinalStage sortOrder(Optional<SortOrder> var1);

        public _FinalStage sortOrder(SortOrder var1);
    }

    public static interface SortFieldStage {
        public _FinalStage sortField(@NotNull SearchOrdersSortField var1);

        public Builder from(SearchOrdersSort var1);
    }
}

