/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ScheduledShiftQuery;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchScheduledShiftsRequest {
    private final Optional<ScheduledShiftQuery> query;
    private final Optional<Integer> limit;
    private final Optional<String> cursor;
    private final Map<String, Object> additionalProperties;

    private SearchScheduledShiftsRequest(Optional<ScheduledShiftQuery> query, Optional<Integer> limit, Optional<String> cursor, Map<String, Object> additionalProperties) {
        this.query = query;
        this.limit = limit;
        this.cursor = cursor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="query")
    public Optional<ScheduledShiftQuery> getQuery() {
        return this.query;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchScheduledShiftsRequest && this.equalTo((SearchScheduledShiftsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchScheduledShiftsRequest other) {
        return this.query.equals(other.query) && this.limit.equals(other.limit) && this.cursor.equals(other.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.limit, this.cursor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ScheduledShiftQuery> query = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchScheduledShiftsRequest other) {
            this.query(other.getQuery());
            this.limit(other.getLimit());
            this.cursor(other.getCursor());
            return this;
        }

        @JsonSetter(value="query", nulls=Nulls.SKIP)
        public Builder query(Optional<ScheduledShiftQuery> query) {
            this.query = query;
            return this;
        }

        public Builder query(ScheduledShiftQuery query) {
            this.query = Optional.ofNullable(query);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public SearchScheduledShiftsRequest build() {
            return new SearchScheduledShiftsRequest(this.query, this.limit, this.cursor, this.additionalProperties);
        }
    }
}

