/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.FilterValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SegmentFilter {
    private final String serviceVariationId;
    private final Optional<FilterValue> teamMemberIdFilter;
    private final Map<String, Object> additionalProperties;

    private SegmentFilter(String serviceVariationId, Optional<FilterValue> teamMemberIdFilter, Map<String, Object> additionalProperties) {
        this.serviceVariationId = serviceVariationId;
        this.teamMemberIdFilter = teamMemberIdFilter;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="service_variation_id")
    public String getServiceVariationId() {
        return this.serviceVariationId;
    }

    @JsonProperty(value="team_member_id_filter")
    public Optional<FilterValue> getTeamMemberIdFilter() {
        return this.teamMemberIdFilter;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SegmentFilter && this.equalTo((SegmentFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SegmentFilter other) {
        return this.serviceVariationId.equals(other.serviceVariationId) && this.teamMemberIdFilter.equals(other.teamMemberIdFilter);
    }

    public int hashCode() {
        return Objects.hash(this.serviceVariationId, this.teamMemberIdFilter);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ServiceVariationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ServiceVariationIdStage,
    _FinalStage {
        private String serviceVariationId;
        private Optional<FilterValue> teamMemberIdFilter = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SegmentFilter other) {
            this.serviceVariationId(other.getServiceVariationId());
            this.teamMemberIdFilter(other.getTeamMemberIdFilter());
            return this;
        }

        @Override
        @JsonSetter(value="service_variation_id")
        public _FinalStage serviceVariationId(@NotNull String serviceVariationId) {
            this.serviceVariationId = Objects.requireNonNull(serviceVariationId, "serviceVariationId must not be null");
            return this;
        }

        @Override
        public _FinalStage teamMemberIdFilter(FilterValue teamMemberIdFilter) {
            this.teamMemberIdFilter = Optional.ofNullable(teamMemberIdFilter);
            return this;
        }

        @Override
        @JsonSetter(value="team_member_id_filter", nulls=Nulls.SKIP)
        public _FinalStage teamMemberIdFilter(Optional<FilterValue> teamMemberIdFilter) {
            this.teamMemberIdFilter = teamMemberIdFilter;
            return this;
        }

        @Override
        public SegmentFilter build() {
            return new SegmentFilter(this.serviceVariationId, this.teamMemberIdFilter, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SegmentFilter build();

        public _FinalStage teamMemberIdFilter(Optional<FilterValue> var1);

        public _FinalStage teamMemberIdFilter(FilterValue var1);
    }

    public static interface ServiceVariationIdStage {
        public _FinalStage serviceVariationId(@NotNull String var1);

        public Builder from(SegmentFilter var1);
    }
}

