/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SelectOption {
    private final String referenceId;
    private final String title;
    private final Map<String, Object> additionalProperties;

    private SelectOption(String referenceId, String title, Map<String, Object> additionalProperties) {
        this.referenceId = referenceId;
        this.title = title;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="reference_id")
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SelectOption && this.equalTo((SelectOption)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SelectOption other) {
        return this.referenceId.equals(other.referenceId) && this.title.equals(other.title);
    }

    public int hashCode() {
        return Objects.hash(this.referenceId, this.title);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ReferenceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ReferenceIdStage,
    TitleStage,
    _FinalStage {
        private String referenceId;
        private String title;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SelectOption other) {
            this.referenceId(other.getReferenceId());
            this.title(other.getTitle());
            return this;
        }

        @Override
        @JsonSetter(value="reference_id")
        public TitleStage referenceId(@NotNull String referenceId) {
            this.referenceId = Objects.requireNonNull(referenceId, "referenceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public _FinalStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        public SelectOption build() {
            return new SelectOption(this.referenceId, this.title, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SelectOption build();
    }

    public static interface TitleStage {
        public _FinalStage title(@NotNull String var1);
    }

    public static interface ReferenceIdStage {
        public TitleStage referenceId(@NotNull String var1);

        public Builder from(SelectOption var1);
    }
}

