/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Break;
import com.squareup.square.types.Money;
import com.squareup.square.types.ShiftStatus;
import com.squareup.square.types.ShiftWage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Shift {
    private final Optional<String> id;
    private final Optional<String> employeeId;
    private final String locationId;
    private final Optional<String> timezone;
    private final String startAt;
    private final Optional<String> endAt;
    private final Optional<ShiftWage> wage;
    private final Optional<List<Break>> breaks;
    private final Optional<ShiftStatus> status;
    private final Optional<Integer> version;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> teamMemberId;
    private final Optional<Money> declaredCashTipMoney;
    private final Map<String, Object> additionalProperties;

    private Shift(Optional<String> id, Optional<String> employeeId, String locationId, Optional<String> timezone, String startAt, Optional<String> endAt, Optional<ShiftWage> wage, Optional<List<Break>> breaks, Optional<ShiftStatus> status, Optional<Integer> version, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> teamMemberId, Optional<Money> declaredCashTipMoney, Map<String, Object> additionalProperties) {
        this.id = id;
        this.employeeId = employeeId;
        this.locationId = locationId;
        this.timezone = timezone;
        this.startAt = startAt;
        this.endAt = endAt;
        this.wage = wage;
        this.breaks = breaks;
        this.status = status;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.teamMemberId = teamMemberId;
        this.declaredCashTipMoney = declaredCashTipMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getEmployeeId() {
        if (this.employeeId == null) {
            return Optional.empty();
        }
        return this.employeeId;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getTimezone() {
        if (this.timezone == null) {
            return Optional.empty();
        }
        return this.timezone;
    }

    @JsonProperty(value="start_at")
    public String getStartAt() {
        return this.startAt;
    }

    @JsonIgnore
    public Optional<String> getEndAt() {
        if (this.endAt == null) {
            return Optional.empty();
        }
        return this.endAt;
    }

    @JsonProperty(value="wage")
    public Optional<ShiftWage> getWage() {
        return this.wage;
    }

    @JsonIgnore
    public Optional<List<Break>> getBreaks() {
        if (this.breaks == null) {
            return Optional.empty();
        }
        return this.breaks;
    }

    @JsonProperty(value="status")
    public Optional<ShiftStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<String> getTeamMemberId() {
        if (this.teamMemberId == null) {
            return Optional.empty();
        }
        return this.teamMemberId;
    }

    @JsonProperty(value="declared_cash_tip_money")
    public Optional<Money> getDeclaredCashTipMoney() {
        return this.declaredCashTipMoney;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="employee_id")
    private Optional<String> _getEmployeeId() {
        return this.employeeId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="timezone")
    private Optional<String> _getTimezone() {
        return this.timezone;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="end_at")
    private Optional<String> _getEndAt() {
        return this.endAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="breaks")
    private Optional<List<Break>> _getBreaks() {
        return this.breaks;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="team_member_id")
    private Optional<String> _getTeamMemberId() {
        return this.teamMemberId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Shift && this.equalTo((Shift)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Shift other) {
        return this.id.equals(other.id) && this.employeeId.equals(other.employeeId) && this.locationId.equals(other.locationId) && this.timezone.equals(other.timezone) && this.startAt.equals(other.startAt) && this.endAt.equals(other.endAt) && this.wage.equals(other.wage) && this.breaks.equals(other.breaks) && this.status.equals(other.status) && this.version.equals(other.version) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.teamMemberId.equals(other.teamMemberId) && this.declaredCashTipMoney.equals(other.declaredCashTipMoney);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.employeeId, this.locationId, this.timezone, this.startAt, this.endAt, this.wage, this.breaks, this.status, this.version, this.createdAt, this.updatedAt, this.teamMemberId, this.declaredCashTipMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    StartAtStage,
    _FinalStage {
        private String locationId;
        private String startAt;
        private Optional<Money> declaredCashTipMoney = Optional.empty();
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<ShiftStatus> status = Optional.empty();
        private Optional<List<Break>> breaks = Optional.empty();
        private Optional<ShiftWage> wage = Optional.empty();
        private Optional<String> endAt = Optional.empty();
        private Optional<String> timezone = Optional.empty();
        private Optional<String> employeeId = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Shift other) {
            this.id(other.getId());
            this.employeeId(other.getEmployeeId());
            this.locationId(other.getLocationId());
            this.timezone(other.getTimezone());
            this.startAt(other.getStartAt());
            this.endAt(other.getEndAt());
            this.wage(other.getWage());
            this.breaks(other.getBreaks());
            this.status(other.getStatus());
            this.version(other.getVersion());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.teamMemberId(other.getTeamMemberId());
            this.declaredCashTipMoney(other.getDeclaredCashTipMoney());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public StartAtStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="start_at")
        public _FinalStage startAt(@NotNull String startAt) {
            this.startAt = Objects.requireNonNull(startAt, "startAt must not be null");
            return this;
        }

        @Override
        public _FinalStage declaredCashTipMoney(Money declaredCashTipMoney) {
            this.declaredCashTipMoney = Optional.ofNullable(declaredCashTipMoney);
            return this;
        }

        @Override
        @JsonSetter(value="declared_cash_tip_money", nulls=Nulls.SKIP)
        public _FinalStage declaredCashTipMoney(Optional<Money> declaredCashTipMoney) {
            this.declaredCashTipMoney = declaredCashTipMoney;
            return this;
        }

        @Override
        public _FinalStage teamMemberId(Nullable<String> teamMemberId) {
            this.teamMemberId = teamMemberId.isNull() ? null : (teamMemberId.isEmpty() ? Optional.empty() : Optional.of(teamMemberId.get()));
            return this;
        }

        @Override
        public _FinalStage teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        @Override
        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public _FinalStage teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        @Override
        public _FinalStage updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage status(ShiftStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<ShiftStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage breaks(Nullable<List<Break>> breaks) {
            this.breaks = breaks.isNull() ? null : (breaks.isEmpty() ? Optional.empty() : Optional.of(breaks.get()));
            return this;
        }

        @Override
        public _FinalStage breaks(List<Break> breaks) {
            this.breaks = Optional.ofNullable(breaks);
            return this;
        }

        @Override
        @JsonSetter(value="breaks", nulls=Nulls.SKIP)
        public _FinalStage breaks(Optional<List<Break>> breaks) {
            this.breaks = breaks;
            return this;
        }

        @Override
        public _FinalStage wage(ShiftWage wage) {
            this.wage = Optional.ofNullable(wage);
            return this;
        }

        @Override
        @JsonSetter(value="wage", nulls=Nulls.SKIP)
        public _FinalStage wage(Optional<ShiftWage> wage) {
            this.wage = wage;
            return this;
        }

        @Override
        public _FinalStage endAt(Nullable<String> endAt) {
            this.endAt = endAt.isNull() ? null : (endAt.isEmpty() ? Optional.empty() : Optional.of(endAt.get()));
            return this;
        }

        @Override
        public _FinalStage endAt(String endAt) {
            this.endAt = Optional.ofNullable(endAt);
            return this;
        }

        @Override
        @JsonSetter(value="end_at", nulls=Nulls.SKIP)
        public _FinalStage endAt(Optional<String> endAt) {
            this.endAt = endAt;
            return this;
        }

        @Override
        public _FinalStage timezone(Nullable<String> timezone) {
            this.timezone = timezone.isNull() ? null : (timezone.isEmpty() ? Optional.empty() : Optional.of(timezone.get()));
            return this;
        }

        @Override
        public _FinalStage timezone(String timezone) {
            this.timezone = Optional.ofNullable(timezone);
            return this;
        }

        @Override
        @JsonSetter(value="timezone", nulls=Nulls.SKIP)
        public _FinalStage timezone(Optional<String> timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public _FinalStage employeeId(Nullable<String> employeeId) {
            this.employeeId = employeeId.isNull() ? null : (employeeId.isEmpty() ? Optional.empty() : Optional.of(employeeId.get()));
            return this;
        }

        @Override
        public _FinalStage employeeId(String employeeId) {
            this.employeeId = Optional.ofNullable(employeeId);
            return this;
        }

        @Override
        @JsonSetter(value="employee_id", nulls=Nulls.SKIP)
        public _FinalStage employeeId(Optional<String> employeeId) {
            this.employeeId = employeeId;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public Shift build() {
            return new Shift(this.id, this.employeeId, this.locationId, this.timezone, this.startAt, this.endAt, this.wage, this.breaks, this.status, this.version, this.createdAt, this.updatedAt, this.teamMemberId, this.declaredCashTipMoney, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Shift build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage employeeId(Optional<String> var1);

        public _FinalStage employeeId(String var1);

        public _FinalStage employeeId(Nullable<String> var1);

        public _FinalStage timezone(Optional<String> var1);

        public _FinalStage timezone(String var1);

        public _FinalStage timezone(Nullable<String> var1);

        public _FinalStage endAt(Optional<String> var1);

        public _FinalStage endAt(String var1);

        public _FinalStage endAt(Nullable<String> var1);

        public _FinalStage wage(Optional<ShiftWage> var1);

        public _FinalStage wage(ShiftWage var1);

        public _FinalStage breaks(Optional<List<Break>> var1);

        public _FinalStage breaks(List<Break> var1);

        public _FinalStage breaks(Nullable<List<Break>> var1);

        public _FinalStage status(Optional<ShiftStatus> var1);

        public _FinalStage status(ShiftStatus var1);

        public _FinalStage version(Optional<Integer> var1);

        public _FinalStage version(Integer var1);

        public _FinalStage createdAt(Optional<String> var1);

        public _FinalStage createdAt(String var1);

        public _FinalStage updatedAt(Optional<String> var1);

        public _FinalStage updatedAt(String var1);

        public _FinalStage teamMemberId(Optional<String> var1);

        public _FinalStage teamMemberId(String var1);

        public _FinalStage teamMemberId(Nullable<String> var1);

        public _FinalStage declaredCashTipMoney(Optional<Money> var1);

        public _FinalStage declaredCashTipMoney(Money var1);
    }

    public static interface StartAtStage {
        public _FinalStage startAt(@NotNull String var1);
    }

    public static interface LocationIdStage {
        public StartAtStage locationId(@NotNull String var1);

        public Builder from(Shift var1);
    }
}

