/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ShippingFee {
    private final Optional<String> name;
    private final Money charge;
    private final Map<String, Object> additionalProperties;

    private ShippingFee(Optional<String> name, Money charge, Map<String, Object> additionalProperties) {
        this.name = name;
        this.charge = charge;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonProperty(value="charge")
    public Money getCharge() {
        return this.charge;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ShippingFee && this.equalTo((ShippingFee)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShippingFee other) {
        return this.name.equals(other.name) && this.charge.equals(other.charge);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.charge);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ChargeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ChargeStage,
    _FinalStage {
        private Money charge;
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ShippingFee other) {
            this.name(other.getName());
            this.charge(other.getCharge());
            return this;
        }

        @Override
        @JsonSetter(value="charge")
        public _FinalStage charge(@NotNull Money charge) {
            this.charge = Objects.requireNonNull(charge, "charge must not be null");
            return this;
        }

        @Override
        public _FinalStage name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public ShippingFee build() {
            return new ShippingFee(this.name, this.charge, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ShippingFee build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage name(Nullable<String> var1);
    }

    public static interface ChargeStage {
        public _FinalStage charge(@NotNull Money var1);

        public Builder from(ShippingFee var1);
    }
}

