/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SignatureImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SignatureOptions {
    private final String title;
    private final String body;
    private final Optional<List<SignatureImage>> signature;
    private final Map<String, Object> additionalProperties;

    private SignatureOptions(String title, String body, Optional<List<SignatureImage>> signature, Map<String, Object> additionalProperties) {
        this.title = title;
        this.body = body;
        this.signature = signature;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonProperty(value="signature")
    public Optional<List<SignatureImage>> getSignature() {
        return this.signature;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SignatureOptions && this.equalTo((SignatureOptions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SignatureOptions other) {
        return this.title.equals(other.title) && this.body.equals(other.body) && this.signature.equals(other.signature);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.signature);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TitleStage,
    BodyStage,
    _FinalStage {
        private String title;
        private String body;
        private Optional<List<SignatureImage>> signature = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SignatureOptions other) {
            this.title(other.getTitle());
            this.body(other.getBody());
            this.signature(other.getSignature());
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public BodyStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public _FinalStage signature(List<SignatureImage> signature) {
            this.signature = Optional.ofNullable(signature);
            return this;
        }

        @Override
        @JsonSetter(value="signature", nulls=Nulls.SKIP)
        public _FinalStage signature(Optional<List<SignatureImage>> signature) {
            this.signature = signature;
            return this;
        }

        @Override
        public SignatureOptions build() {
            return new SignatureOptions(this.title, this.body, this.signature, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SignatureOptions build();

        public _FinalStage signature(Optional<List<SignatureImage>> var1);

        public _FinalStage signature(List<SignatureImage> var1);
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull String var1);
    }

    public static interface TitleStage {
        public BodyStage title(@NotNull String var1);

        public Builder from(SignatureOptions var1);
    }
}

