/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Site {
    private final Optional<String> id;
    private final Optional<String> siteTitle;
    private final Optional<String> domain;
    private final Optional<Boolean> isPublished;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Map<String, Object> additionalProperties;

    private Site(Optional<String> id, Optional<String> siteTitle, Optional<String> domain, Optional<Boolean> isPublished, Optional<String> createdAt, Optional<String> updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.siteTitle = siteTitle;
        this.domain = domain;
        this.isPublished = isPublished;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getSiteTitle() {
        if (this.siteTitle == null) {
            return Optional.empty();
        }
        return this.siteTitle;
    }

    @JsonIgnore
    public Optional<String> getDomain() {
        if (this.domain == null) {
            return Optional.empty();
        }
        return this.domain;
    }

    @JsonIgnore
    public Optional<Boolean> getIsPublished() {
        if (this.isPublished == null) {
            return Optional.empty();
        }
        return this.isPublished;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="site_title")
    private Optional<String> _getSiteTitle() {
        return this.siteTitle;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="domain")
    private Optional<String> _getDomain() {
        return this.domain;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_published")
    private Optional<Boolean> _getIsPublished() {
        return this.isPublished;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Site && this.equalTo((Site)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Site other) {
        return this.id.equals(other.id) && this.siteTitle.equals(other.siteTitle) && this.domain.equals(other.domain) && this.isPublished.equals(other.isPublished) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.siteTitle, this.domain, this.isPublished, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> siteTitle = Optional.empty();
        private Optional<String> domain = Optional.empty();
        private Optional<Boolean> isPublished = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Site other) {
            this.id(other.getId());
            this.siteTitle(other.getSiteTitle());
            this.domain(other.getDomain());
            this.isPublished(other.getIsPublished());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="site_title", nulls=Nulls.SKIP)
        public Builder siteTitle(Optional<String> siteTitle) {
            this.siteTitle = siteTitle;
            return this;
        }

        public Builder siteTitle(String siteTitle) {
            this.siteTitle = Optional.ofNullable(siteTitle);
            return this;
        }

        public Builder siteTitle(Nullable<String> siteTitle) {
            this.siteTitle = siteTitle.isNull() ? null : (siteTitle.isEmpty() ? Optional.empty() : Optional.of(siteTitle.get()));
            return this;
        }

        @JsonSetter(value="domain", nulls=Nulls.SKIP)
        public Builder domain(Optional<String> domain) {
            this.domain = domain;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = Optional.ofNullable(domain);
            return this;
        }

        public Builder domain(Nullable<String> domain) {
            this.domain = domain.isNull() ? null : (domain.isEmpty() ? Optional.empty() : Optional.of(domain.get()));
            return this;
        }

        @JsonSetter(value="is_published", nulls=Nulls.SKIP)
        public Builder isPublished(Optional<Boolean> isPublished) {
            this.isPublished = isPublished;
            return this;
        }

        public Builder isPublished(Boolean isPublished) {
            this.isPublished = Optional.ofNullable(isPublished);
            return this;
        }

        public Builder isPublished(Nullable<Boolean> isPublished) {
            this.isPublished = isPublished.isNull() ? null : (isPublished.isEmpty() ? Optional.empty() : Optional.of(isPublished.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public Site build() {
            return new Site(this.id, this.siteTitle, this.domain, this.isPublished, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }
}

