/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Phase;
import com.squareup.square.types.SubscriptionEventInfo;
import com.squareup.square.types.SubscriptionEventSubscriptionEventType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubscriptionEvent {
    private final String id;
    private final SubscriptionEventSubscriptionEventType subscriptionEventType;
    private final String effectiveDate;
    private final Optional<Integer> monthlyBillingAnchorDate;
    private final Optional<SubscriptionEventInfo> info;
    private final Optional<List<Phase>> phases;
    private final String planVariationId;
    private final Map<String, Object> additionalProperties;

    private SubscriptionEvent(String id, SubscriptionEventSubscriptionEventType subscriptionEventType, String effectiveDate, Optional<Integer> monthlyBillingAnchorDate, Optional<SubscriptionEventInfo> info, Optional<List<Phase>> phases, String planVariationId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.subscriptionEventType = subscriptionEventType;
        this.effectiveDate = effectiveDate;
        this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
        this.info = info;
        this.phases = phases;
        this.planVariationId = planVariationId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="subscription_event_type")
    public SubscriptionEventSubscriptionEventType getSubscriptionEventType() {
        return this.subscriptionEventType;
    }

    @JsonProperty(value="effective_date")
    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonProperty(value="monthly_billing_anchor_date")
    public Optional<Integer> getMonthlyBillingAnchorDate() {
        return this.monthlyBillingAnchorDate;
    }

    @JsonProperty(value="info")
    public Optional<SubscriptionEventInfo> getInfo() {
        return this.info;
    }

    @JsonIgnore
    public Optional<List<Phase>> getPhases() {
        if (this.phases == null) {
            return Optional.empty();
        }
        return this.phases;
    }

    @JsonProperty(value="plan_variation_id")
    public String getPlanVariationId() {
        return this.planVariationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phases")
    private Optional<List<Phase>> _getPhases() {
        return this.phases;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubscriptionEvent && this.equalTo((SubscriptionEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionEvent other) {
        return this.id.equals(other.id) && this.subscriptionEventType.equals(other.subscriptionEventType) && this.effectiveDate.equals(other.effectiveDate) && this.monthlyBillingAnchorDate.equals(other.monthlyBillingAnchorDate) && this.info.equals(other.info) && this.phases.equals(other.phases) && this.planVariationId.equals(other.planVariationId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.subscriptionEventType, this.effectiveDate, this.monthlyBillingAnchorDate, this.info, this.phases, this.planVariationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    SubscriptionEventTypeStage,
    EffectiveDateStage,
    PlanVariationIdStage,
    _FinalStage {
        private String id;
        private SubscriptionEventSubscriptionEventType subscriptionEventType;
        private String effectiveDate;
        private String planVariationId;
        private Optional<List<Phase>> phases = Optional.empty();
        private Optional<SubscriptionEventInfo> info = Optional.empty();
        private Optional<Integer> monthlyBillingAnchorDate = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SubscriptionEvent other) {
            this.id(other.getId());
            this.subscriptionEventType(other.getSubscriptionEventType());
            this.effectiveDate(other.getEffectiveDate());
            this.monthlyBillingAnchorDate(other.getMonthlyBillingAnchorDate());
            this.info(other.getInfo());
            this.phases(other.getPhases());
            this.planVariationId(other.getPlanVariationId());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public SubscriptionEventTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="subscription_event_type")
        public EffectiveDateStage subscriptionEventType(@NotNull SubscriptionEventSubscriptionEventType subscriptionEventType) {
            this.subscriptionEventType = Objects.requireNonNull(subscriptionEventType, "subscriptionEventType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="effective_date")
        public PlanVariationIdStage effectiveDate(@NotNull String effectiveDate) {
            this.effectiveDate = Objects.requireNonNull(effectiveDate, "effectiveDate must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_variation_id")
        public _FinalStage planVariationId(@NotNull String planVariationId) {
            this.planVariationId = Objects.requireNonNull(planVariationId, "planVariationId must not be null");
            return this;
        }

        @Override
        public _FinalStage phases(Nullable<List<Phase>> phases) {
            this.phases = phases.isNull() ? null : (phases.isEmpty() ? Optional.empty() : Optional.of(phases.get()));
            return this;
        }

        @Override
        public _FinalStage phases(List<Phase> phases) {
            this.phases = Optional.ofNullable(phases);
            return this;
        }

        @Override
        @JsonSetter(value="phases", nulls=Nulls.SKIP)
        public _FinalStage phases(Optional<List<Phase>> phases) {
            this.phases = phases;
            return this;
        }

        @Override
        public _FinalStage info(SubscriptionEventInfo info) {
            this.info = Optional.ofNullable(info);
            return this;
        }

        @Override
        @JsonSetter(value="info", nulls=Nulls.SKIP)
        public _FinalStage info(Optional<SubscriptionEventInfo> info) {
            this.info = info;
            return this;
        }

        @Override
        public _FinalStage monthlyBillingAnchorDate(Integer monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = Optional.ofNullable(monthlyBillingAnchorDate);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_billing_anchor_date", nulls=Nulls.SKIP)
        public _FinalStage monthlyBillingAnchorDate(Optional<Integer> monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
            return this;
        }

        @Override
        public SubscriptionEvent build() {
            return new SubscriptionEvent(this.id, this.subscriptionEventType, this.effectiveDate, this.monthlyBillingAnchorDate, this.info, this.phases, this.planVariationId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SubscriptionEvent build();

        public _FinalStage monthlyBillingAnchorDate(Optional<Integer> var1);

        public _FinalStage monthlyBillingAnchorDate(Integer var1);

        public _FinalStage info(Optional<SubscriptionEventInfo> var1);

        public _FinalStage info(SubscriptionEventInfo var1);

        public _FinalStage phases(Optional<List<Phase>> var1);

        public _FinalStage phases(List<Phase> var1);

        public _FinalStage phases(Nullable<List<Phase>> var1);
    }

    public static interface PlanVariationIdStage {
        public _FinalStage planVariationId(@NotNull String var1);
    }

    public static interface EffectiveDateStage {
        public PlanVariationIdStage effectiveDate(@NotNull String var1);
    }

    public static interface SubscriptionEventTypeStage {
        public EffectiveDateStage subscriptionEventType(@NotNull SubscriptionEventSubscriptionEventType var1);
    }

    public static interface IdStage {
        public SubscriptionEventTypeStage id(@NotNull String var1);

        public Builder from(SubscriptionEvent var1);
    }
}

