/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SubscriptionEventInfoCode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubscriptionEventInfo {
    private final Optional<String> detail;
    private final Optional<SubscriptionEventInfoCode> code;
    private final Map<String, Object> additionalProperties;

    private SubscriptionEventInfo(Optional<String> detail, Optional<SubscriptionEventInfoCode> code, Map<String, Object> additionalProperties) {
        this.detail = detail;
        this.code = code;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getDetail() {
        if (this.detail == null) {
            return Optional.empty();
        }
        return this.detail;
    }

    @JsonProperty(value="code")
    public Optional<SubscriptionEventInfoCode> getCode() {
        return this.code;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="detail")
    private Optional<String> _getDetail() {
        return this.detail;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubscriptionEventInfo && this.equalTo((SubscriptionEventInfo)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionEventInfo other) {
        return this.detail.equals(other.detail) && this.code.equals(other.code);
    }

    public int hashCode() {
        return Objects.hash(this.detail, this.code);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> detail = Optional.empty();
        private Optional<SubscriptionEventInfoCode> code = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SubscriptionEventInfo other) {
            this.detail(other.getDetail());
            this.code(other.getCode());
            return this;
        }

        @JsonSetter(value="detail", nulls=Nulls.SKIP)
        public Builder detail(Optional<String> detail) {
            this.detail = detail;
            return this;
        }

        public Builder detail(String detail) {
            this.detail = Optional.ofNullable(detail);
            return this;
        }

        public Builder detail(Nullable<String> detail) {
            this.detail = detail.isNull() ? null : (detail.isEmpty() ? Optional.empty() : Optional.of(detail.get()));
            return this;
        }

        @JsonSetter(value="code", nulls=Nulls.SKIP)
        public Builder code(Optional<SubscriptionEventInfoCode> code) {
            this.code = code;
            return this;
        }

        public Builder code(SubscriptionEventInfoCode code) {
            this.code = Optional.ofNullable(code);
            return this;
        }

        public SubscriptionEventInfo build() {
            return new SubscriptionEventInfo(this.detail, this.code, this.additionalProperties);
        }
    }
}

