/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Subscription;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubscriptionUpdatedEventObject {
    private final Optional<Subscription> subscription;
    private final Map<String, Object> additionalProperties;

    private SubscriptionUpdatedEventObject(Optional<Subscription> subscription, Map<String, Object> additionalProperties) {
        this.subscription = subscription;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="subscription")
    public Optional<Subscription> getSubscription() {
        return this.subscription;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubscriptionUpdatedEventObject && this.equalTo((SubscriptionUpdatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionUpdatedEventObject other) {
        return this.subscription.equals(other.subscription);
    }

    public int hashCode() {
        return Objects.hash(this.subscription);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Subscription> subscription = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SubscriptionUpdatedEventObject other) {
            this.subscription(other.getSubscription());
            return this;
        }

        @JsonSetter(value="subscription", nulls=Nulls.SKIP)
        public Builder subscription(Optional<Subscription> subscription) {
            this.subscription = subscription;
            return this;
        }

        public Builder subscription(Subscription subscription) {
            this.subscription = Optional.ofNullable(subscription);
            return this;
        }

        public SubscriptionUpdatedEventObject build() {
            return new SubscriptionUpdatedEventObject(this.subscription, this.additionalProperties);
        }
    }
}

