/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.PhaseInput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SwapPlanRequest {
    private final String subscriptionId;
    private final Optional<String> newPlanVariationId;
    private final Optional<List<PhaseInput>> phases;
    private final Map<String, Object> additionalProperties;

    private SwapPlanRequest(String subscriptionId, Optional<String> newPlanVariationId, Optional<List<PhaseInput>> phases, Map<String, Object> additionalProperties) {
        this.subscriptionId = subscriptionId;
        this.newPlanVariationId = newPlanVariationId;
        this.phases = phases;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="subscription_id")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonIgnore
    public Optional<String> getNewPlanVariationId() {
        if (this.newPlanVariationId == null) {
            return Optional.empty();
        }
        return this.newPlanVariationId;
    }

    @JsonIgnore
    public Optional<List<PhaseInput>> getPhases() {
        if (this.phases == null) {
            return Optional.empty();
        }
        return this.phases;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="new_plan_variation_id")
    private Optional<String> _getNewPlanVariationId() {
        return this.newPlanVariationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phases")
    private Optional<List<PhaseInput>> _getPhases() {
        return this.phases;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SwapPlanRequest && this.equalTo((SwapPlanRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SwapPlanRequest other) {
        return this.subscriptionId.equals(other.subscriptionId) && this.newPlanVariationId.equals(other.newPlanVariationId) && this.phases.equals(other.phases);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionId, this.newPlanVariationId, this.phases);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SubscriptionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SubscriptionIdStage,
    _FinalStage {
        private String subscriptionId;
        private Optional<List<PhaseInput>> phases = Optional.empty();
        private Optional<String> newPlanVariationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SwapPlanRequest other) {
            this.subscriptionId(other.getSubscriptionId());
            this.newPlanVariationId(other.getNewPlanVariationId());
            this.phases(other.getPhases());
            return this;
        }

        @Override
        @JsonSetter(value="subscription_id")
        public _FinalStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @Override
        public _FinalStage phases(Nullable<List<PhaseInput>> phases) {
            this.phases = phases.isNull() ? null : (phases.isEmpty() ? Optional.empty() : Optional.of(phases.get()));
            return this;
        }

        @Override
        public _FinalStage phases(List<PhaseInput> phases) {
            this.phases = Optional.ofNullable(phases);
            return this;
        }

        @Override
        @JsonSetter(value="phases", nulls=Nulls.SKIP)
        public _FinalStage phases(Optional<List<PhaseInput>> phases) {
            this.phases = phases;
            return this;
        }

        @Override
        public _FinalStage newPlanVariationId(Nullable<String> newPlanVariationId) {
            this.newPlanVariationId = newPlanVariationId.isNull() ? null : (newPlanVariationId.isEmpty() ? Optional.empty() : Optional.of(newPlanVariationId.get()));
            return this;
        }

        @Override
        public _FinalStage newPlanVariationId(String newPlanVariationId) {
            this.newPlanVariationId = Optional.ofNullable(newPlanVariationId);
            return this;
        }

        @Override
        @JsonSetter(value="new_plan_variation_id", nulls=Nulls.SKIP)
        public _FinalStage newPlanVariationId(Optional<String> newPlanVariationId) {
            this.newPlanVariationId = newPlanVariationId;
            return this;
        }

        @Override
        public SwapPlanRequest build() {
            return new SwapPlanRequest(this.subscriptionId, this.newPlanVariationId, this.phases, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SwapPlanRequest build();

        public _FinalStage newPlanVariationId(Optional<String> var1);

        public _FinalStage newPlanVariationId(String var1);

        public _FinalStage newPlanVariationId(Nullable<String> var1);

        public _FinalStage phases(Optional<List<PhaseInput>> var1);

        public _FinalStage phases(List<PhaseInput> var1);

        public _FinalStage phases(Nullable<List<PhaseInput>> var1);
    }

    public static interface SubscriptionIdStage {
        public _FinalStage subscriptionId(@NotNull String var1);

        public Builder from(SwapPlanRequest var1);
    }
}

