/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Card;
import com.squareup.square.types.TenderCardDetailsEntryMethod;
import com.squareup.square.types.TenderCardDetailsStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TenderCardDetails {
    private final Optional<TenderCardDetailsStatus> status;
    private final Optional<Card> card;
    private final Optional<TenderCardDetailsEntryMethod> entryMethod;
    private final Map<String, Object> additionalProperties;

    private TenderCardDetails(Optional<TenderCardDetailsStatus> status, Optional<Card> card, Optional<TenderCardDetailsEntryMethod> entryMethod, Map<String, Object> additionalProperties) {
        this.status = status;
        this.card = card;
        this.entryMethod = entryMethod;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="status")
    public Optional<TenderCardDetailsStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="card")
    public Optional<Card> getCard() {
        return this.card;
    }

    @JsonProperty(value="entry_method")
    public Optional<TenderCardDetailsEntryMethod> getEntryMethod() {
        return this.entryMethod;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TenderCardDetails && this.equalTo((TenderCardDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TenderCardDetails other) {
        return this.status.equals(other.status) && this.card.equals(other.card) && this.entryMethod.equals(other.entryMethod);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.card, this.entryMethod);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<TenderCardDetailsStatus> status = Optional.empty();
        private Optional<Card> card = Optional.empty();
        private Optional<TenderCardDetailsEntryMethod> entryMethod = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TenderCardDetails other) {
            this.status(other.getStatus());
            this.card(other.getCard());
            this.entryMethod(other.getEntryMethod());
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<TenderCardDetailsStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(TenderCardDetailsStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="card", nulls=Nulls.SKIP)
        public Builder card(Optional<Card> card) {
            this.card = card;
            return this;
        }

        public Builder card(Card card) {
            this.card = Optional.ofNullable(card);
            return this;
        }

        @JsonSetter(value="entry_method", nulls=Nulls.SKIP)
        public Builder entryMethod(Optional<TenderCardDetailsEntryMethod> entryMethod) {
            this.entryMethod = entryMethod;
            return this;
        }

        public Builder entryMethod(TenderCardDetailsEntryMethod entryMethod) {
            this.entryMethod = Optional.ofNullable(entryMethod);
            return this;
        }

        public TenderCardDetails build() {
            return new TenderCardDetails(this.status, this.card, this.entryMethod, this.additionalProperties);
        }
    }
}

