/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ActionCancelReason;
import com.squareup.square.types.ConfirmationOptions;
import com.squareup.square.types.DataCollectionOptions;
import com.squareup.square.types.DeviceMetadata;
import com.squareup.square.types.QrCodeOptions;
import com.squareup.square.types.ReceiptOptions;
import com.squareup.square.types.SaveCardOptions;
import com.squareup.square.types.SelectOptions;
import com.squareup.square.types.SignatureOptions;
import com.squareup.square.types.TerminalActionActionType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TerminalAction {
    private final Optional<String> id;
    private final Optional<String> deviceId;
    private final Optional<String> deadlineDuration;
    private final Optional<String> status;
    private final Optional<ActionCancelReason> cancelReason;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> appId;
    private final Optional<String> locationId;
    private final Optional<TerminalActionActionType> type;
    private final Optional<QrCodeOptions> qrCodeOptions;
    private final Optional<SaveCardOptions> saveCardOptions;
    private final Optional<SignatureOptions> signatureOptions;
    private final Optional<ConfirmationOptions> confirmationOptions;
    private final Optional<ReceiptOptions> receiptOptions;
    private final Optional<DataCollectionOptions> dataCollectionOptions;
    private final Optional<SelectOptions> selectOptions;
    private final Optional<DeviceMetadata> deviceMetadata;
    private final Optional<Boolean> awaitNextAction;
    private final Optional<String> awaitNextActionDuration;
    private final Map<String, Object> additionalProperties;

    private TerminalAction(Optional<String> id, Optional<String> deviceId, Optional<String> deadlineDuration, Optional<String> status, Optional<ActionCancelReason> cancelReason, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> appId, Optional<String> locationId, Optional<TerminalActionActionType> type, Optional<QrCodeOptions> qrCodeOptions, Optional<SaveCardOptions> saveCardOptions, Optional<SignatureOptions> signatureOptions, Optional<ConfirmationOptions> confirmationOptions, Optional<ReceiptOptions> receiptOptions, Optional<DataCollectionOptions> dataCollectionOptions, Optional<SelectOptions> selectOptions, Optional<DeviceMetadata> deviceMetadata, Optional<Boolean> awaitNextAction, Optional<String> awaitNextActionDuration, Map<String, Object> additionalProperties) {
        this.id = id;
        this.deviceId = deviceId;
        this.deadlineDuration = deadlineDuration;
        this.status = status;
        this.cancelReason = cancelReason;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.appId = appId;
        this.locationId = locationId;
        this.type = type;
        this.qrCodeOptions = qrCodeOptions;
        this.saveCardOptions = saveCardOptions;
        this.signatureOptions = signatureOptions;
        this.confirmationOptions = confirmationOptions;
        this.receiptOptions = receiptOptions;
        this.dataCollectionOptions = dataCollectionOptions;
        this.selectOptions = selectOptions;
        this.deviceMetadata = deviceMetadata;
        this.awaitNextAction = awaitNextAction;
        this.awaitNextActionDuration = awaitNextActionDuration;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getDeviceId() {
        if (this.deviceId == null) {
            return Optional.empty();
        }
        return this.deviceId;
    }

    @JsonIgnore
    public Optional<String> getDeadlineDuration() {
        if (this.deadlineDuration == null) {
            return Optional.empty();
        }
        return this.deadlineDuration;
    }

    @JsonProperty(value="status")
    public Optional<String> getStatus() {
        return this.status;
    }

    @JsonProperty(value="cancel_reason")
    public Optional<ActionCancelReason> getCancelReason() {
        return this.cancelReason;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="app_id")
    public Optional<String> getAppId() {
        return this.appId;
    }

    @JsonProperty(value="location_id")
    public Optional<String> getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="type")
    public Optional<TerminalActionActionType> getType() {
        return this.type;
    }

    @JsonProperty(value="qr_code_options")
    public Optional<QrCodeOptions> getQrCodeOptions() {
        return this.qrCodeOptions;
    }

    @JsonProperty(value="save_card_options")
    public Optional<SaveCardOptions> getSaveCardOptions() {
        return this.saveCardOptions;
    }

    @JsonProperty(value="signature_options")
    public Optional<SignatureOptions> getSignatureOptions() {
        return this.signatureOptions;
    }

    @JsonProperty(value="confirmation_options")
    public Optional<ConfirmationOptions> getConfirmationOptions() {
        return this.confirmationOptions;
    }

    @JsonProperty(value="receipt_options")
    public Optional<ReceiptOptions> getReceiptOptions() {
        return this.receiptOptions;
    }

    @JsonProperty(value="data_collection_options")
    public Optional<DataCollectionOptions> getDataCollectionOptions() {
        return this.dataCollectionOptions;
    }

    @JsonProperty(value="select_options")
    public Optional<SelectOptions> getSelectOptions() {
        return this.selectOptions;
    }

    @JsonProperty(value="device_metadata")
    public Optional<DeviceMetadata> getDeviceMetadata() {
        return this.deviceMetadata;
    }

    @JsonIgnore
    public Optional<Boolean> getAwaitNextAction() {
        if (this.awaitNextAction == null) {
            return Optional.empty();
        }
        return this.awaitNextAction;
    }

    @JsonIgnore
    public Optional<String> getAwaitNextActionDuration() {
        if (this.awaitNextActionDuration == null) {
            return Optional.empty();
        }
        return this.awaitNextActionDuration;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="device_id")
    private Optional<String> _getDeviceId() {
        return this.deviceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="deadline_duration")
    private Optional<String> _getDeadlineDuration() {
        return this.deadlineDuration;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="await_next_action")
    private Optional<Boolean> _getAwaitNextAction() {
        return this.awaitNextAction;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="await_next_action_duration")
    private Optional<String> _getAwaitNextActionDuration() {
        return this.awaitNextActionDuration;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TerminalAction && this.equalTo((TerminalAction)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TerminalAction other) {
        return this.id.equals(other.id) && this.deviceId.equals(other.deviceId) && this.deadlineDuration.equals(other.deadlineDuration) && this.status.equals(other.status) && this.cancelReason.equals(other.cancelReason) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.appId.equals(other.appId) && this.locationId.equals(other.locationId) && this.type.equals(other.type) && this.qrCodeOptions.equals(other.qrCodeOptions) && this.saveCardOptions.equals(other.saveCardOptions) && this.signatureOptions.equals(other.signatureOptions) && this.confirmationOptions.equals(other.confirmationOptions) && this.receiptOptions.equals(other.receiptOptions) && this.dataCollectionOptions.equals(other.dataCollectionOptions) && this.selectOptions.equals(other.selectOptions) && this.deviceMetadata.equals(other.deviceMetadata) && this.awaitNextAction.equals(other.awaitNextAction) && this.awaitNextActionDuration.equals(other.awaitNextActionDuration);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.deviceId, this.deadlineDuration, this.status, this.cancelReason, this.createdAt, this.updatedAt, this.appId, this.locationId, this.type, this.qrCodeOptions, this.saveCardOptions, this.signatureOptions, this.confirmationOptions, this.receiptOptions, this.dataCollectionOptions, this.selectOptions, this.deviceMetadata, this.awaitNextAction, this.awaitNextActionDuration);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> deviceId = Optional.empty();
        private Optional<String> deadlineDuration = Optional.empty();
        private Optional<String> status = Optional.empty();
        private Optional<ActionCancelReason> cancelReason = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> appId = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<TerminalActionActionType> type = Optional.empty();
        private Optional<QrCodeOptions> qrCodeOptions = Optional.empty();
        private Optional<SaveCardOptions> saveCardOptions = Optional.empty();
        private Optional<SignatureOptions> signatureOptions = Optional.empty();
        private Optional<ConfirmationOptions> confirmationOptions = Optional.empty();
        private Optional<ReceiptOptions> receiptOptions = Optional.empty();
        private Optional<DataCollectionOptions> dataCollectionOptions = Optional.empty();
        private Optional<SelectOptions> selectOptions = Optional.empty();
        private Optional<DeviceMetadata> deviceMetadata = Optional.empty();
        private Optional<Boolean> awaitNextAction = Optional.empty();
        private Optional<String> awaitNextActionDuration = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TerminalAction other) {
            this.id(other.getId());
            this.deviceId(other.getDeviceId());
            this.deadlineDuration(other.getDeadlineDuration());
            this.status(other.getStatus());
            this.cancelReason(other.getCancelReason());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.appId(other.getAppId());
            this.locationId(other.getLocationId());
            this.type(other.getType());
            this.qrCodeOptions(other.getQrCodeOptions());
            this.saveCardOptions(other.getSaveCardOptions());
            this.signatureOptions(other.getSignatureOptions());
            this.confirmationOptions(other.getConfirmationOptions());
            this.receiptOptions(other.getReceiptOptions());
            this.dataCollectionOptions(other.getDataCollectionOptions());
            this.selectOptions(other.getSelectOptions());
            this.deviceMetadata(other.getDeviceMetadata());
            this.awaitNextAction(other.getAwaitNextAction());
            this.awaitNextActionDuration(other.getAwaitNextActionDuration());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="device_id", nulls=Nulls.SKIP)
        public Builder deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = Optional.ofNullable(deviceId);
            return this;
        }

        public Builder deviceId(Nullable<String> deviceId) {
            this.deviceId = deviceId.isNull() ? null : (deviceId.isEmpty() ? Optional.empty() : Optional.of(deviceId.get()));
            return this;
        }

        @JsonSetter(value="deadline_duration", nulls=Nulls.SKIP)
        public Builder deadlineDuration(Optional<String> deadlineDuration) {
            this.deadlineDuration = deadlineDuration;
            return this;
        }

        public Builder deadlineDuration(String deadlineDuration) {
            this.deadlineDuration = Optional.ofNullable(deadlineDuration);
            return this;
        }

        public Builder deadlineDuration(Nullable<String> deadlineDuration) {
            this.deadlineDuration = deadlineDuration.isNull() ? null : (deadlineDuration.isEmpty() ? Optional.empty() : Optional.of(deadlineDuration.get()));
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<String> status) {
            this.status = status;
            return this;
        }

        public Builder status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="cancel_reason", nulls=Nulls.SKIP)
        public Builder cancelReason(Optional<ActionCancelReason> cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public Builder cancelReason(ActionCancelReason cancelReason) {
            this.cancelReason = Optional.ofNullable(cancelReason);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="app_id", nulls=Nulls.SKIP)
        public Builder appId(Optional<String> appId) {
            this.appId = appId;
            return this;
        }

        public Builder appId(String appId) {
            this.appId = Optional.ofNullable(appId);
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<TerminalActionActionType> type) {
            this.type = type;
            return this;
        }

        public Builder type(TerminalActionActionType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="qr_code_options", nulls=Nulls.SKIP)
        public Builder qrCodeOptions(Optional<QrCodeOptions> qrCodeOptions) {
            this.qrCodeOptions = qrCodeOptions;
            return this;
        }

        public Builder qrCodeOptions(QrCodeOptions qrCodeOptions) {
            this.qrCodeOptions = Optional.ofNullable(qrCodeOptions);
            return this;
        }

        @JsonSetter(value="save_card_options", nulls=Nulls.SKIP)
        public Builder saveCardOptions(Optional<SaveCardOptions> saveCardOptions) {
            this.saveCardOptions = saveCardOptions;
            return this;
        }

        public Builder saveCardOptions(SaveCardOptions saveCardOptions) {
            this.saveCardOptions = Optional.ofNullable(saveCardOptions);
            return this;
        }

        @JsonSetter(value="signature_options", nulls=Nulls.SKIP)
        public Builder signatureOptions(Optional<SignatureOptions> signatureOptions) {
            this.signatureOptions = signatureOptions;
            return this;
        }

        public Builder signatureOptions(SignatureOptions signatureOptions) {
            this.signatureOptions = Optional.ofNullable(signatureOptions);
            return this;
        }

        @JsonSetter(value="confirmation_options", nulls=Nulls.SKIP)
        public Builder confirmationOptions(Optional<ConfirmationOptions> confirmationOptions) {
            this.confirmationOptions = confirmationOptions;
            return this;
        }

        public Builder confirmationOptions(ConfirmationOptions confirmationOptions) {
            this.confirmationOptions = Optional.ofNullable(confirmationOptions);
            return this;
        }

        @JsonSetter(value="receipt_options", nulls=Nulls.SKIP)
        public Builder receiptOptions(Optional<ReceiptOptions> receiptOptions) {
            this.receiptOptions = receiptOptions;
            return this;
        }

        public Builder receiptOptions(ReceiptOptions receiptOptions) {
            this.receiptOptions = Optional.ofNullable(receiptOptions);
            return this;
        }

        @JsonSetter(value="data_collection_options", nulls=Nulls.SKIP)
        public Builder dataCollectionOptions(Optional<DataCollectionOptions> dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions;
            return this;
        }

        public Builder dataCollectionOptions(DataCollectionOptions dataCollectionOptions) {
            this.dataCollectionOptions = Optional.ofNullable(dataCollectionOptions);
            return this;
        }

        @JsonSetter(value="select_options", nulls=Nulls.SKIP)
        public Builder selectOptions(Optional<SelectOptions> selectOptions) {
            this.selectOptions = selectOptions;
            return this;
        }

        public Builder selectOptions(SelectOptions selectOptions) {
            this.selectOptions = Optional.ofNullable(selectOptions);
            return this;
        }

        @JsonSetter(value="device_metadata", nulls=Nulls.SKIP)
        public Builder deviceMetadata(Optional<DeviceMetadata> deviceMetadata) {
            this.deviceMetadata = deviceMetadata;
            return this;
        }

        public Builder deviceMetadata(DeviceMetadata deviceMetadata) {
            this.deviceMetadata = Optional.ofNullable(deviceMetadata);
            return this;
        }

        @JsonSetter(value="await_next_action", nulls=Nulls.SKIP)
        public Builder awaitNextAction(Optional<Boolean> awaitNextAction) {
            this.awaitNextAction = awaitNextAction;
            return this;
        }

        public Builder awaitNextAction(Boolean awaitNextAction) {
            this.awaitNextAction = Optional.ofNullable(awaitNextAction);
            return this;
        }

        public Builder awaitNextAction(Nullable<Boolean> awaitNextAction) {
            this.awaitNextAction = awaitNextAction.isNull() ? null : (awaitNextAction.isEmpty() ? Optional.empty() : Optional.of(awaitNextAction.get()));
            return this;
        }

        @JsonSetter(value="await_next_action_duration", nulls=Nulls.SKIP)
        public Builder awaitNextActionDuration(Optional<String> awaitNextActionDuration) {
            this.awaitNextActionDuration = awaitNextActionDuration;
            return this;
        }

        public Builder awaitNextActionDuration(String awaitNextActionDuration) {
            this.awaitNextActionDuration = Optional.ofNullable(awaitNextActionDuration);
            return this;
        }

        public Builder awaitNextActionDuration(Nullable<String> awaitNextActionDuration) {
            this.awaitNextActionDuration = awaitNextActionDuration.isNull() ? null : (awaitNextActionDuration.isEmpty() ? Optional.empty() : Optional.of(awaitNextActionDuration.get()));
            return this;
        }

        public TerminalAction build() {
            return new TerminalAction(this.id, this.deviceId, this.deadlineDuration, this.status, this.cancelReason, this.createdAt, this.updatedAt, this.appId, this.locationId, this.type, this.qrCodeOptions, this.saveCardOptions, this.signatureOptions, this.confirmationOptions, this.receiptOptions, this.dataCollectionOptions, this.selectOptions, this.deviceMetadata, this.awaitNextAction, this.awaitNextActionDuration, this.additionalProperties);
        }
    }
}

