/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TerminalActionActionType;
import com.squareup.square.types.TimeRange;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TerminalActionQueryFilter {
    private final Optional<String> deviceId;
    private final Optional<TimeRange> createdAt;
    private final Optional<String> status;
    private final Optional<TerminalActionActionType> type;
    private final Map<String, Object> additionalProperties;

    private TerminalActionQueryFilter(Optional<String> deviceId, Optional<TimeRange> createdAt, Optional<String> status, Optional<TerminalActionActionType> type, Map<String, Object> additionalProperties) {
        this.deviceId = deviceId;
        this.createdAt = createdAt;
        this.status = status;
        this.type = type;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getDeviceId() {
        if (this.deviceId == null) {
            return Optional.empty();
        }
        return this.deviceId;
    }

    @JsonProperty(value="created_at")
    public Optional<TimeRange> getCreatedAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public Optional<String> getStatus() {
        if (this.status == null) {
            return Optional.empty();
        }
        return this.status;
    }

    @JsonProperty(value="type")
    public Optional<TerminalActionActionType> getType() {
        return this.type;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="device_id")
    private Optional<String> _getDeviceId() {
        return this.deviceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="status")
    private Optional<String> _getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TerminalActionQueryFilter && this.equalTo((TerminalActionQueryFilter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TerminalActionQueryFilter other) {
        return this.deviceId.equals(other.deviceId) && this.createdAt.equals(other.createdAt) && this.status.equals(other.status) && this.type.equals(other.type);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.createdAt, this.status, this.type);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> deviceId = Optional.empty();
        private Optional<TimeRange> createdAt = Optional.empty();
        private Optional<String> status = Optional.empty();
        private Optional<TerminalActionActionType> type = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TerminalActionQueryFilter other) {
            this.deviceId(other.getDeviceId());
            this.createdAt(other.getCreatedAt());
            this.status(other.getStatus());
            this.type(other.getType());
            return this;
        }

        @JsonSetter(value="device_id", nulls=Nulls.SKIP)
        public Builder deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = Optional.ofNullable(deviceId);
            return this;
        }

        public Builder deviceId(Nullable<String> deviceId) {
            this.deviceId = deviceId.isNull() ? null : (deviceId.isEmpty() ? Optional.empty() : Optional.of(deviceId.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<TimeRange> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(TimeRange createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<String> status) {
            this.status = status;
            return this;
        }

        public Builder status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Nullable<String> status) {
            this.status = status.isNull() ? null : (status.isEmpty() ? Optional.empty() : Optional.of(status.get()));
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<TerminalActionActionType> type) {
            this.type = type;
            return this;
        }

        public Builder type(TerminalActionActionType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        public TerminalActionQueryFilter build() {
            return new TerminalActionQueryFilter(this.deviceId, this.createdAt, this.status, this.type, this.additionalProperties);
        }
    }
}

