/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TerminalRefundQuerySort {
    private final Optional<String> sortOrder;
    private final Map<String, Object> additionalProperties;

    private TerminalRefundQuerySort(Optional<String> sortOrder, Map<String, Object> additionalProperties) {
        this.sortOrder = sortOrder;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getSortOrder() {
        if (this.sortOrder == null) {
            return Optional.empty();
        }
        return this.sortOrder;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sort_order")
    private Optional<String> _getSortOrder() {
        return this.sortOrder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TerminalRefundQuerySort && this.equalTo((TerminalRefundQuerySort)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TerminalRefundQuerySort other) {
        return this.sortOrder.equals(other.sortOrder);
    }

    public int hashCode() {
        return Objects.hash(this.sortOrder);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> sortOrder = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TerminalRefundQuerySort other) {
            this.sortOrder(other.getSortOrder());
            return this;
        }

        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public Builder sortOrder(Optional<String> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        public Builder sortOrder(Nullable<String> sortOrder) {
            this.sortOrder = sortOrder.isNull() ? null : (sortOrder.isEmpty() ? Optional.empty() : Optional.of(sortOrder.get()));
            return this;
        }

        public TerminalRefundQuerySort build() {
            return new TerminalRefundQuerySort(this.sortOrder, this.additionalProperties);
        }
    }
}

